# Welcome

If you're here because you want to contribute to Anytime - thank you! There are many ways in which you can
help this project.

## Testing

This is by far one of the biggest ways you can support the project. Please try out Anytime and
report back any issues or bugs you find. If you have suggestions for improvements or new
features, please report them too.

## Reporting a bug or feature request

Report a bug or feature request
by [opening a new issue](https://github.com/amugofjava/anytime_podcast_player/issues) -
it's that easy!

## Contributing code
If you would like to work on a feature that has been requested or fix a bug that has been reported
  via an issue, add
  a comment to it so that other people know that you are working on it. If you would like to work on
  a feature that has
  not been reported, please first discuss the change you wish to make either
  via
  an [issue](https://github.com/amugofjava/anytime_podcast_player/issues)
  or [email](mailto:hello@anytimeplayer.app).

Once you are ready to code: 

- Fork the repo and create a branch from `master`.
- If you've added code that should be tested, add tests and ensure the test suite passes.
- If the code you are contributing is non-trivial, please ensure your code is commented. This not
  only helps when reviewing pull requests, but also helps other developers who may be new to the
  code.
- Make sure your code lints.
- If your code contains labels and strings, they will need translating. Check out [TRANSLATION.md](TRANSLATION.md) for
  more information on how Anytime handles multiple languages.
- If your code alters the UI, ensure the changes are accessible and work with both Android TalkBack and iOS VoiceOver. If 
you are unable to test on both Android & iOS, please reach out to me via a comment and I can help with the testing.
- Format your code with `dartfmt --line-length 120`. Note that the project uses 120 chars and not
  the default 80. Most IDEs will do this for you on save but, if not, you may need to do this
  manually.
- Squash your commits. If you have made several commits, but they are all part of the same logical
  change, please squash them down to a single commit; this both helps the pull request
  approval process and keeps the history cleaner. If you've never squashed commits before there is
  a good
  article [here](https://medium.com/@slamflipstrom/a-beginners-guide-to-squashing-commits-with-git-rebase-8185cf6e62ec),
  or you can reach out to [me](mailto:anytime@amugofjava.me.uk) if you need some help.
- Issue a pull request.

## Translating Anytime

If you would like to translate the app into another language or improve an existing translation,
please
take a look at [TRANSLATION.md](TRANSLATION.md) for further details.

## License

By contributing, you agree that your contributions will be under the BSD-style license defined in
the [LICENSE](LICENSE) file.