# Core Logic TODOs

This file tracks bugs and missing features in the core keyboard logic (parsing, event handling, etc.).

## 🟠 MEDIUM PRIORITY BUGS (From TODO_MEDIUM_LOW.md)

### Configuration (1 bug)
- [x] **Bug #75**: CharKey flags hardcoded to emptySet() ✅ FIXED (2025-11-12)
  - File: ComposeKey.kt (File 13)
  - Impact: Some compose key flags lost
  - Fix: Replaced direct CharKey() constructor with KeyValue.makeCharKey() factory method
  - Commit: 876e995e
  - Severity: MEDIUM

- [x] **Bug #80**: TRIGGER_CHARACTERS expanded beyond Java ❌ FALSE (2025-11-13)
  - File: Autocapitalisation.kt (File 15) - Note: todo incorrectly listed as File 14
  - Status: NOT A BUG - Both Java and Kotlin versions only trigger on space character
  - Java: `is_trigger_character(c)` returns true only for ' ' (space)
  - Kotlin: `isTriggerCharacter(c)` returns true only for ' ' (space)
  - Impact: None - identical behavior
  - Severity: N/A (false report)

## 🟡 LOW PRIORITY BUGS (From TODO_MEDIUM_LOW.md)

### Code Quality (1 bug)
- [x] **Bug #77**: LegacyComposeSystem - 90 lines of UNUSED dead code ❌ FALSE (2025-11-13)
  - File: ComposeKey.kt (File 13)
  - Status: NOT A BUG - LegacyComposeSystem IS used in KeyModifier.kt:156
  - Used by: applyComposeOrFallback() method for compose sequence fallback
  - Impact: Code bloat only
  - Severity: LOW

- [x] **Bug #272**: TracePoint comment incorrect ✅ FIXED (2025-11-13)
  - File: SwipeMLData.kt (File 70)
  - Impact: Documentation only
  - Fix: Added proper KDoc with @property annotations for x, y (normalized [0,1]) and tDeltaMs (time delta from previous point)
  - Severity: LOW

---

## 📋 REVIEW STATUS (Updated 2025-11-16)

**Progress**: ✅ **183/183 files reviewed (100% COMPLETE)**
**Remaining**: **0 files**

**Status**: 🎉 **ALL FILES REVIEWED!**

**Note**: Original estimate of 251 files was incorrect. Actual codebase has 183 Kotlin files.

**Latest Reviews**:
- [x] Files 142-149: Multi-Language (5,341 lines) - 8 bugs FIXED
- [x] Files 150-157: Advanced Input (5,210 lines) - 8 bugs FIXED
- [x] Files 158-165: Autocorrection/Prediction (3,663 lines) - 8 bugs FIXED
- [x] Files 182-236 gap: Only 18 actual files (4,489 lines) - 24 bugs FIXED

**See**: `docs/COMPLETE_REVIEW_STATUS.md` for full timeline

---

## 🟢 CORE SYSTEM BUGS

- File 1: 1 critical (KeyValueParser 96% missing)
- File 2: 23 critical (Keyboard2 ~800 lines missing)
- File 4: 1 critical (Config.handler = null)
- File 7: 8 critical (KeyEventHandler 22% missing - no macros, editing keys, sliders)
- File 11: **11 CATASTROPHIC → ✅ ALL FALSE** (KeyModifier - ✅ VERIFIED 2025-11-16: 192 lines functional, proper sealed classes, modify() works, modern Kotlin idioms)
  - **Status**: ❌ FALSE - All 11 bugs are documentation errors
  - **Evidence**: Sealed class hierarchy (Shift/Ctrl/Alt/Meta/Fn), ModifierState with active/locked/temp, applyToKey() working
  - **Commits**: 68f381e4, 38d5d670, f95df799
  - **Verification**: VERIFICATION_FILES_11_16_51.md
- File 12: **✅ 0 bugs** (Modmap - PROPERLY IMPLEMENTED, improvements over Java)
- File 13: **1 bug** (ComposeKey - ✅ FIXED Bug #75 flags hardcoded; ⏳ REMAINING: 90 lines unused code)
- File 14: **✅ 0 bugs** (ComposeKeyData - ✅ FIXED with code generation: Bug #78 FIXED - 8659 states loaded from compose_data.bin)
- File 15: **0 bugs** (Autocapitalisation - ❌ Bug #80 FALSE: trigger logic identical to Java)
- File 16: **1 CATASTROPHIC → ✅ FIXED** (ExtraKeys - ✅ VERIFIED 2025-11-16: 197 lines, Bug #266 P0 explicitly FIXED)
  - **Status**: ✅ FIXED - Complete ExtraKeys system implementation
  - **Evidence**: CustomExtraKeysPreference integrated, R.string resources used properly
  - **Commits**: 22b9c323 (Bug #266 fix), 38f62d8f, 4cf39084
  - **Verification**: VERIFICATION_FILES_11_16_51.md
- File 17: **1 CRITICAL → 0 bugs** (DirectBootAwarePreferences - ✅ FIXED: device-protected storage, migration logic, full implementation)
- File 18: **✅ 0 bugs** (Utils - ✅ EXEMPLARY! 7X expansion with enhancements)
- File 20: **3 bugs → 0 bugs** (Logs - ✅ FIXED: TAG constant, debug_startup_input_view(), trace())
- File 51: **4 CATASTROPHIC bugs → ✅ ALL FALSE** (R.kt - ✅ VERIFIED 2025-11-16: R class auto-generated correctly by Android build system)
  - **Status**: ❌ FALSE - All 4 bugs are documentation errors, build system works correctly
  - **Evidence**: No manual R.kt in src/main/, :processDebugResources succeeds, multiple files import tribixbite.keyboard2.R successfully, 50MB APK compiles
  - **Note**: BuildConfig.kt is separate configuration object (not R class)
  - **Verification**: VERIFICATION_FILES_11_16_51.md
- File 52: **5 bugs** (Resources.kt - CRITICAL: entire file is band-aid for R.kt issue; HIGH: silent failures without logging; MEDIUM: wrong type handling for Int, catches all exceptions; LOW: inconsistent fallback API)
- File 101: ✅ **ErrorHandling.java (est. 300-400 lines) vs ErrorHandling.kt (252 lines) - ✅ EXCELLENT**
- File 105: ✅ **ConfigurationManager.java (est. 700-900 lines) vs ConfigurationManager.kt (513 lines) - ✅ EXCELLENT (CRITICAL memory leak Bug #291)**
- File 107: ✅ **UtilityClasses.java (est. 200-300 lines scattered) vs Extensions.kt (104 lines) - ✅ EXCELLENT (ZERO BUGS, FIXES 12 OTHER BUGS)**
- File 108: ✅ **ValidationTests.java (est. 600-800 lines scattered) vs RuntimeValidator.kt (461 lines) - ✅ EXCELLENT**
- File 110: ✅ **SystemIntegrationTests.java (est. 600-800 lines scattered) vs SystemIntegrationTester.kt (448 lines) - ✅ EXCELLENT**
