# Privacy Policy - CleverKeys

**Effective Date**: TBD (To be set at release)
**Last Updated**: 2025-11-16
**Version**: 1.0

---

## Our Privacy Commitment

**CleverKeys is built on a simple principle: Your data is YOURS and YOURS ALONE.**

We don't collect it. We don't store it. We don't share it. We don't even have the ability to access it.

---

## The Short Version

**CleverKeys collects ZERO data. Period.**

- ❌ No usage statistics
- ❌ No analytics
- ❌ No crash reports
- ❌ No typing data
- ❌ No personal information
- ❌ No cloud sync
- ❌ No third-party services
- ❌ No ads or tracking

**Everything happens locally on your device. Always.**

---

## The Complete Privacy Policy

### 1. Information Collection

**CleverKeys does NOT collect, store, transmit, or process any personal information.**

Specifically, we do NOT collect:
- **Typing Data**: What you type stays on your device
- **Word Predictions**: Generated locally, never sent anywhere
- **Dictionary Data**: Stored locally in your device storage
- **Usage Statistics**: We have no idea how you use the app
- **Crash Reports**: Not collected (we can't see if the app crashes)
- **Device Information**: We don't know your device model, OS version, or anything else
- **Location Data**: Never accessed or collected
- **Contact Information**: Not requested or stored
- **Personal Identifiers**: No user IDs, device IDs, or advertising IDs

### 2. Data Processing

**All data processing happens locally on your device:**

#### What Stays on Your Device
- **User Dictionary**: Custom words you add
- **Word Frequency**: Words you use often (for personalization)
- **Keyboard Settings**: Your preferences and customizations
- **Layout Configurations**: Your keyboard layouts and extra keys
- **Training Data**: Swipe patterns for ML model improvement (local only)
- **Clipboard History**: If enabled, stored locally only

#### How We Don't Process Data
- **No Cloud Storage**: Nothing is ever sent to servers
- **No Remote Processing**: All AI/ML runs on your device
- **No Backup to Cloud**: Your data doesn't leave your device
- **No Cross-Device Sync**: Intentionally not supported

### 3. Data Sharing

**CleverKeys NEVER shares your data with anyone because we don't have your data to share.**

We do NOT share data with:
- ❌ Third-party analytics services
- ❌ Advertising networks
- ❌ Social media platforms
- ❌ Cloud storage providers
- ❌ Other apps or services
- ❌ Government agencies (we have nothing to share)
- ❌ Anyone else (there's no data to share)

### 4. Third-Party Services

**CleverKeys does NOT use any third-party services.**

No integrations with:
- ❌ Google Analytics
- ❌ Firebase
- ❌ Crashlytics
- ❌ Facebook SDK
- ❌ Any advertising networks
- ❌ Any cloud services
- ❌ Any tracking services

**The only "third party" involved is the Android operating system itself, which is necessary for the keyboard to function.**

### 5. Permissions

**CleverKeys requests ZERO permissions.**

Unlike many keyboards, CleverKeys does NOT require:
- ❌ Internet access
- ❌ Location access
- ❌ Contact access
- ❌ Camera access
- ❌ Microphone access
- ❌ Storage access (beyond standard app data)
- ❌ Phone state access
- ❌ Any other sensitive permissions

**Standard Android permissions granted automatically:**
- ✅ Vibration (for haptic feedback)
- ✅ App storage (for settings and dictionary)

**Optional permissions (user-controlled):**
- System settings access (only if you enable accessibility features)
- Clipboard access (only if you use clipboard history feature)

### 6. Data Storage

**All data is stored locally on your device in standard Android app storage:**

#### Storage Locations
- **Settings**: Android SharedPreferences
- **Dictionary**: SQLite database (local)
- **Training Data**: SQLite database (local)
- **Layouts**: XML files (local)
- **User Words**: SQLite database (local)

#### Storage Security
- Protected by Android's app sandboxing
- Encrypted if you enable device encryption
- Deleted when you uninstall the app
- Never backed up to cloud (intentionally disabled)

### 7. Data Retention

**Data is retained locally on your device until you:**
- Uninstall the app (all data deleted automatically)
- Clear app data manually (Settings → Apps → CleverKeys → Clear Data)
- Delete specific items (words, layouts, etc.)

**We cannot delete your data because we don't have it.**

### 8. Children's Privacy

**CleverKeys is safe for all ages because we collect no data from anyone.**

- Compliant with COPPA (Children's Online Privacy Protection Act)
- Compliant with GDPR requirements for children
- No age verification needed (no data collection)
- Safe for use by children without parental consent

### 9. International Users

**CleverKeys works the same everywhere because there's no data transmission.**

- **GDPR Compliant** (EU): No data collection = automatic compliance
- **CCPA Compliant** (California): No data to sell or share
- **PIPEDA Compliant** (Canada): No personal information collected
- **LGPD Compliant** (Brazil): No data processing
- **All Other Jurisdictions**: Same privacy guarantee worldwide

### 10. Open Source Transparency

**CleverKeys is open source. You can verify our privacy claims:**

- **Source Code**: Available on GitHub (URL TBD)
- **License**: GPL-3.0 (same as Unexpected-Keyboard)
- **Audit**: Anyone can review the code
- **Build**: Reproducible builds for verification
- **No Hidden Code**: What you see is what you get

**Network Activity Check:**
- Run a network monitor while using CleverKeys
- You'll see ZERO network connections
- No DNS queries, no HTTP requests, nothing

### 11. Changes to This Policy

**If we ever change our privacy practices (we won't), we'll update this policy.**

How you'll know:
- Version number will increment
- "Last Updated" date will change
- Notification in app update notes
- Posted on GitHub repository

**Current commitment: Zero data collection will NEVER change.**

### 12. Contact Information

**For privacy questions or concerns:**

- **Email**: [Your email address]
- **GitHub**: [Repository URL]/issues
- **Website**: [Your website]

**Note**: We can't help with lost data because we don't have backups (no cloud storage). Please backup your settings manually if needed.

### 13. Your Rights

**Under GDPR, CCPA, and other privacy laws, you have rights:**

| Right | How CleverKeys Handles It |
|-------|---------------------------|
| **Right to Access** | Not applicable - we have no data about you |
| **Right to Deletion** | Not applicable - we have no data to delete |
| **Right to Correction** | Not applicable - we have no data to correct |
| **Right to Portability** | You can export settings manually |
| **Right to Object** | Not applicable - no processing to object to |
| **Right to Opt Out** | Not applicable - nothing to opt out of |

### 14. Data Security

**How we protect your data: By not having it.**

- **Encryption**: Your device encryption protects local data
- **Transmission**: Nothing is transmitted (100% secure)
- **Breaches**: Impossible - we have no servers to breach
- **Hackers**: Can't steal what doesn't exist on servers
- **Government Requests**: Nothing to provide

**Your responsibility:**
- Lock your device (screen lock, encryption)
- Don't root your device (unless you know what you're doing)
- Keep Android updated (security patches)

### 15. Cookies and Tracking

**CleverKeys uses ZERO cookies or tracking technologies.**

- ❌ No cookies
- ❌ No web beacons
- ❌ No fingerprinting
- ❌ No tracking pixels
- ❌ No session IDs
- ❌ No unique identifiers

**There's no website or server, so there's nothing to track.**

### 16. Advertising

**CleverKeys contains ZERO advertising.**

- ❌ No ads
- ❌ No ad networks
- ❌ No sponsored content
- ❌ No affiliate links
- ❌ No promotional content

**It's free because it's open source, not because we monetize your data.**

### 17. Compliance Summary

**CleverKeys is compliant with:**

✅ **GDPR** (General Data Protection Regulation - EU)
✅ **CCPA** (California Consumer Privacy Act - USA)
✅ **COPPA** (Children's Online Privacy Protection Act - USA)
✅ **PIPEDA** (Personal Information Protection - Canada)
✅ **LGPD** (Lei Geral de Proteção de Dados - Brazil)
✅ **Privacy Shield** (EU-US data transfers - not applicable)
✅ **HIPAA** (Healthcare privacy - by not collecting data)
✅ **All other privacy regulations** (no data = automatic compliance)

---

## Comparison to Other Keyboards

### CleverKeys vs. Typical Keyboard Apps

| Feature | CleverKeys | Typical Keyboard |
|---------|------------|------------------|
| **Data Collection** | ❌ None | ✅ Extensive |
| **Cloud Sync** | ❌ No | ✅ Yes |
| **Analytics** | ❌ No | ✅ Yes |
| **Ads** | ❌ No | ✅ Often |
| **Internet** | ❌ Not needed | ✅ Required |
| **Privacy Policy** | ✅ Simple | ⚠️ Complex |
| **Data Sharing** | ❌ None | ✅ Third parties |
| **Transparency** | ✅ Open source | ❌ Proprietary |

---

## Frequently Asked Privacy Questions

### Q: Why don't you collect usage statistics to improve the app?
**A**: We value your privacy more than our convenience. We improve the app through open source contributions and user feedback, not surveillance.

### Q: How can you fix bugs without crash reports?
**A**: Users can manually report bugs with as much or as little detail as they choose. We respect their right to privacy.

### Q: Don't you need data to improve predictions?
**A**: No. The ML model trains locally on your device using your typing patterns. Your data never leaves your device.

### Q: What if I want to sync my settings across devices?
**A**: We intentionally don't support this to ensure privacy. You can manually export/import settings if needed.

### Q: How do you make money if you don't collect data?
**A**: We don't. CleverKeys is free, open source software. No monetization, no data collection, no catches.

### Q: Can governments request my typing data?
**A**: They can request, but we have nothing to give. Your data is only on your device.

### Q: What about compliance with lawful intercept requirements?
**A**: Not applicable. We're not a communication service provider, and we don't transmit or store communications.

### Q: Can you recover my deleted words/settings?
**A**: No. We don't have backups because we don't have cloud storage. Once deleted from your device, it's gone forever.

---

## Technical Privacy Details

### Local-Only Architecture

**How CleverKeys Ensures Privacy:**

1. **No Network Code**: The app doesn't contain networking libraries
2. **No Internet Permission**: AndroidManifest.xml doesn't request internet access
3. **No Analytics SDKs**: No third-party analytics integrated
4. **No Telemetry**: No usage tracking code exists
5. **No Remote Config**: All configuration is local
6. **No A/B Testing**: No server-side experiments
7. **No Push Notifications**: No notification service integration

### Verification Methods

**Users can verify our privacy claims:**

1. **Source Code Audit**: Review GitHub repository
2. **Network Monitor**: Use tools like NetGuard or AFWall+ - you'll see zero network activity
3. **Permission Check**: Settings → Apps → CleverKeys → Permissions - you'll see it requests nothing
4. **Decompile APK**: Extract and review the APK - no networking code
5. **DNS Monitoring**: Monitor DNS requests - you'll see none from CleverKeys
6. **Packet Capture**: Use Wireshark or tcpdump - zero packets from CleverKeys

---

## Privacy by Design

**CleverKeys incorporates privacy in its architecture:**

### Design Principles
1. **Data Minimization**: Collect nothing (beyond minimum = zero)
2. **Purpose Limitation**: No data means no purpose to limit
3. **Storage Limitation**: Only local, only as long as needed
4. **Accuracy**: You control your data locally
5. **Integrity**: Protected by Android security
6. **Confidentiality**: Never transmitted anywhere
7. **Transparency**: Open source code
8. **Accountability**: Public repository with issue tracking

---

## Summary

**CleverKeys Privacy Promise:**

✅ Zero data collection
✅ Zero data transmission  
✅ Zero data sharing
✅ Zero advertising
✅ Zero tracking
✅ 100% local processing
✅ 100% open source
✅ 100% private

**Your typing is your business. We'll never make it ours.**

---

## Legal Information

**Developer**: [Your Name/Organization]
**Location**: [Your Jurisdiction]
**Contact**: [Your Email]
**Repository**: [GitHub URL]
**License**: GPL-3.0

---

## Acceptance

**By installing and using CleverKeys, you acknowledge that:**

1. You have read this privacy policy
2. You understand we collect no data
3. All data processing is local to your device
4. No cloud backup or sync is provided
5. You are responsible for your own data backups

---

**Privacy Policy Version**: 1.0
**Effective Date**: [To be set at release]
**Last Updated**: 2025-11-16

---

## Appendix: Privacy Comparison Chart

### Data Collection Comparison

| Data Type | CleverKeys | GBoard | SwiftKey | AnySoftKeyboard |
|-----------|------------|--------|----------|-----------------|
| Typed Text | ❌ No | ✅ Yes | ✅ Yes | ❌ No |
| Usage Stats | ❌ No | ✅ Yes | ✅ Yes | ❌ No |
| Crash Reports | ❌ No | ✅ Yes | ✅ Yes | ⚠️ Optional |
| Dictionary | ✅ Local | ☁️ Cloud | ☁️ Cloud | ✅ Local |
| Settings | ✅ Local | ☁️ Cloud | ☁️ Cloud | ✅ Local |
| Analytics | ❌ No | ✅ Yes | ✅ Yes | ❌ No |
| Ads | ❌ No | ❌ No | ⚠️ Sometimes | ❌ No |

---

**END OF PRIVACY POLICY**

**Questions? Contact us at [Your Email]**
