# Contributors

Thank you to everyone who has contributed to CleverKeys! 🎉

---

## Core Team

### CleverKeys Development Team
**Role**: Complete Kotlin rewrite, architecture, and implementation

**Contributions**:
- Complete Kotlin rewrite of Unexpected-Keyboard (~85,000 lines)
- Neural ONNX pipeline implementation (replacing CGR)
- Material 3 UI design and implementation
- Accessibility features (Switch Access, Mouse Keys)
- Dictionary Manager (3-tab UI)
- Multi-language support (20 languages)
- Comprehensive documentation (7,200+ lines)
- Testing infrastructure and automation

**Timeline**: January 2025 - November 2025 (10+ months)

---

## Original Project

### Jules Aguillon ([@Julow](https://github.com/Julow))
**Project**: [Unexpected-Keyboard](https://github.com/Julow/Unexpected-Keyboard)
**Role**: Original author and maintainer

**Contributions**:
- Original Java implementation of the keyboard
- CGR algorithm for gesture recognition
- Keyboard layout system (89+ layouts)
- Extra keys configuration (85+ keys)
- Privacy-first architecture
- Foundation for CleverKeys

CleverKeys maintains 100% feature parity with Unexpected-Keyboard while adding significant enhancements through the Kotlin rewrite and neural prediction system.

---

## Open Source Libraries

### Major Dependencies

**ONNX Runtime** - Microsoft
- **License**: Apache 2.0
- **Contribution**: Neural network inference engine
- **Version**: 1.19.2
- **Usage**: Core prediction pipeline

**Jetpack Compose** - Google
- **License**: Apache 2.0
- **Contribution**: Modern UI framework
- **Usage**: Settings activities and UI components

**Kotlin Coroutines** - JetBrains
- **License**: Apache 2.0
- **Contribution**: Asynchronous programming
- **Usage**: Reactive data flow throughout app

**Material Components for Android** - Google
- **License**: Apache 2.0
- **Contribution**: Material Design components
- **Usage**: Material 3 theming and components

**Reorderable** - Calvin Liang
- **License**: Apache 2.0
- **Contribution**: Drag-and-drop functionality
- **Usage**: Layout Manager reordering

---

## Community Contributors

### How to Become a Contributor

We welcome contributions from everyone! Here are ways to contribute:

1. **Code Contributions**
   - Bug fixes
   - New features
   - Performance improvements
   - Code refactoring

2. **Documentation**
   - User guides and tutorials
   - API documentation
   - Translation to other languages
   - Blog posts and articles

3. **Testing**
   - Bug reports
   - Testing on different devices
   - Performance testing
   - Accessibility testing

4. **Design**
   - UI/UX improvements
   - Icon and graphic design
   - Keyboard layout designs
   - Theme creation

5. **Community Support**
   - Answering questions in Issues
   - Helping other users
   - Writing tutorials
   - Spreading the word

See [CONTRIBUTING.md](CONTRIBUTING.md) for detailed guidelines.

---

## Recognition Types

Contributors are recognized for different types of contributions:

### 💻 Code Contributors
Direct code contributions to the repository

### 📖 Documentation Contributors
Improvements to documentation, guides, and tutorials

### 🧪 Testing Contributors
Bug reports, testing, and quality assurance

### 🎨 Design Contributors
UI/UX design, graphics, themes, and layouts

### 🌍 Translation Contributors
Localization and translation to different languages

### 💡 Idea Contributors
Feature suggestions and architectural improvements

### 🐛 Bug Reporters
Identifying and reporting issues

### 💬 Community Contributors
Helping others, answering questions, community building

---

## Hall of Fame

*As the project grows, significant contributors will be recognized here*

### Major Contributors
*(To be updated as contributions are made)*

### First Contributors
*(First community PR will be celebrated here!)*

### Most Helpful Community Members
*(Recognized for outstanding community support)*

---

## How Credits Work

### Automatic Recognition

When you contribute to CleverKeys:

1. **Your GitHub username** is automatically recorded in git history
2. **Your contributions** are visible in the commit log
3. **Pull requests** show your participation

### Manual Recognition

For significant contributions, you'll be:

1. **Listed in this file** with your contribution type
2. **Mentioned in release notes** for major releases
3. **Thanked publicly** in community announcements

### Opt-Out

If you prefer not to be publicly recognized:
- Let us know when submitting your contribution
- We'll still appreciate your work, just not publicly

---

## Statistics

### Development Statistics (v1.0.0)

- **Development Time**: 10+ months (January - November 2025)
- **Files Implemented**: 251/251 (100% complete)
- **Lines of Code**: ~85,000+ Kotlin
- **Documentation**: 7,200+ lines
- **Commits**: 108+ on main branch
- **Community Contributors**: *Awaiting first contribution!*

### Current Status

- **Version**: 1.0.0
- **Release Date**: 2025-11-16 (pending testing)
- **Production Score**: 95/100 (Grade A+)
- **Open Source**: GPL-3.0 License

---

## Special Thanks

### Beta Testers
*(To be added after beta testing phase)*

### Bug Reporters
*(To be added as bugs are reported)*

### Feature Requesters
*(To be added as features are requested)*

### Community Supporters
*(To be added as community grows)*

---

## Join Us!

Want to see your name here? We'd love to have you contribute!

**Getting Started**:
1. Read [CONTRIBUTING.md](CONTRIBUTING.md)
2. Check [open issues](https://github.com/OWNER/cleverkeys/issues)
3. Join [discussions](https://github.com/OWNER/cleverkeys/discussions)
4. Submit your first PR!

**Questions?**
- GitHub Discussions: Ask anything!
- Email: [Support Email]
- Documentation: Comprehensive guides available

---

## Attribution

CleverKeys follows the [All Contributors](https://allcontributors.org/) specification for recognizing contributions of all kinds.

All contributions are valued equally, whether it's code, documentation, design, testing, or community support.

---

## License

By contributing to CleverKeys, you agree that your contributions will be licensed under the [GPL-3.0 License](LICENSE), the same license as the project.

This ensures CleverKeys remains free and open source for everyone.

---

**Thank you for being part of CleverKeys!** 💙

Together we're building a privacy-first, accessible, neural-powered keyboard for everyone.

🧠 **Think Faster** • ⌨️ **Type Smarter** • 🔒 **Stay Private** • 🤝 **Build Together**

---

**Last Updated**: 2025-11-16
**Version**: 1.0
**Total Contributors**: 1 (core team) + *awaiting community contributions!*
