package tech.lp2p.thor.data

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey
import java.net.InetAddress
import java.net.InetSocketAddress

@Entity
data class Address(
    @field:PrimaryKey val index: Int,
    @field:ColumnInfo val address: ByteArray,
    @field:ColumnInfo val port: Int
) {
    fun address(): InetSocketAddress {
        return InetSocketAddress(
            InetAddress.getByAddress(address), port
        )
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Address

        if (index != other.index) return false
        if (port != other.port) return false
        if (!address.contentEquals(other.address)) return false

        return true
    }

    override fun hashCode(): Int {
        var result = index
        result = 31 * result + port
        result = 31 * result + address.contentHashCode()
        return result
    }

}
