package tech.lp2p.thor

import android.app.Application
import android.util.Log
import android.webkit.CookieManager
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import tech.lp2p.thor.model.initializeAds
import tech.lp2p.thor.model.initializePlatform
import tech.lp2p.thor.model.platform

class App : Application() {

    override fun onCreate() {
        super.onCreate()

        CookieManager.getInstance().setAcceptCookie(true)

        try {
            initializePlatform(applicationContext)
            initializeAds(applicationContext)
        } catch (throwable: Throwable) {
            debug("App", throwable)
        }

        // set all tasks to inactive
        val scope = CoroutineScope(Dispatchers.IO)
        scope.launch {
            platform().tasks().inactive()
        }
    }
}


@Suppress("SameReturnValue")
private val isDebug: Boolean get() = false

@Suppress("SameReturnValue")
private val isError: Boolean get() = true

fun debug(tag: String, message: String) {
    if (isDebug) {
        Log.e(tag, message)
    }
}

fun debug(tag: String, throwable: Throwable) {
    if (isError) {
        Log.e(tag, throwable.localizedMessage, throwable)
    }
}