package tech.lp2p.thor.model

import android.content.Context
import android.database.Cursor
import android.os.Environment
import android.provider.OpenableColumns
import io.github.remmerw.grid.Work
import io.github.remmerw.idun.newIdun
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import kotlinx.io.asSink
import tech.lp2p.thor.debug


class PnsWorker(val context: Context, val taskId: Long) : Work {

    override suspend fun run() {

        val platform = platform()
        platform.setTaskActive(taskId)

        try {
            val tasks = platform.tasks()
            withContext(Dispatchers.IO) {

                val task = tasks.task(taskId)

                val request = task.uri
                val idun = newIdun(store = platform().store())

                val name = task.name
                val mimeType = task.mimeType


                val targetUri = platform().downloadsUri(
                    mimeType, name,
                    Environment.DIRECTORY_DOWNLOADS
                )
                checkNotNull(targetUri)
                val contentResolver = context.contentResolver
                checkNotNull(contentResolver)
                var offset = 0L

                val cursor: Cursor? = contentResolver.query(
                    targetUri, null, null, null, null
                )
                if (cursor != null) {
                    cursor.moveToFirst()
                    val value = cursor.getColumnIndex(OpenableColumns.SIZE)
                    offset = cursor.getLong(value)
                    cursor.close()
                }

                contentResolver.openOutputStream(targetUri, "wa").use { os ->
                    checkNotNull(os)

                    idun.transferTo(os.asSink(), request, offset) { progress ->
                        launch {
                            tasks.progress(taskId, progress)
                        }
                    }
                }
                tasks.finished(taskId, targetUri.toString())

            }
        } catch (throwable: Throwable) {
            debug("DownloadPnsWorker", throwable)
        } finally {
            platform.setTaskInactive(taskId)
        }
    }
}