package tech.lp2p.thor.model

import android.content.Context
import android.net.Uri
import tech.lp2p.thor.R
import java.io.BufferedReader
import java.io.InputStreamReader


private val AD_HOSTS: MutableSet<String> = mutableSetOf()

fun isAd(uri: Uri): Boolean {
    val host = uri.host
    return isAdHost(host ?: "")
}


fun initializeAds(context: Context) {
    BufferedReader(
        InputStreamReader(
            context.resources.openRawResource(
                R.raw.pgl_yoyo_org
            )
        )
    ).use { reader ->
        while (reader.ready()) {
            val line = reader.readLine()
            AD_HOSTS.add(line)
        }
    }
}

internal fun isAdHost(host: String): Boolean {
    if (host.isEmpty()) {
        return false
    }
    val index = host.indexOf('.')
    return index >= 0 && (AD_HOSTS.contains(host) ||
            index + 1 < host.length && isAdHost(host.substring(index + 1)))
}

