package tech.lp2p.thor.data

import androidx.room.Database
import androidx.room.RoomDatabase
import kotlinx.coroutines.flow.Flow


@Database(entities = [Task::class], version = 1, exportSchema = false)
abstract class Tasks : RoomDatabase() {
    abstract fun tasksDao(): TasksDao

    suspend fun createOrGet(
        pid: Long, name: String, mimeType: String, uri: String,
        size: Long
    ): Long {
        val id = tasksDao().parent(pid, name)
        if (id != null) {
            return id
        }
        return tasksDao().insert(
            Task(
                0, pid, name, mimeType, uri,
                size = size,
                work = null,
                active = false,
                finished = false,
                progress = 0f
            )
        )
    }

    fun active(): Flow<Boolean> {
        return tasksDao().active()
    }

    suspend fun progress(id: Long, progress: Float) {
        tasksDao().progress(id, progress)
    }

    suspend fun inactive(id: Long) {
        tasksDao().inactive(id)
    }

    suspend fun inactive() {
        tasksDao().inactive()
    }

    suspend fun active(id: Long) {
        tasksDao().active(id)
    }

    suspend fun task(id: Long): Task {
        return tasksDao().task(id)
    }

    suspend fun work(id: Long, work: String) {
        tasksDao().work(id, work)
    }

    suspend fun purge() {
        tasksDao().purge()
    }

    suspend fun finished(id: Long, uri: String) {
        tasksDao().finished(id, uri)
    }

    suspend fun finished(id: Long) {
        tasksDao().finished(id)
    }

    fun tasks(pid: Long): Flow<List<Task>> {
        return tasksDao().tasks(pid)
    }

    suspend fun insert(task: Task): Long {
        return tasksDao().insert(task)
    }

    suspend fun delete(task: Task) {
        tasksDao().delete(task)
    }

    suspend fun reset() {
        tasksDao().reset()
    }
}
