package tech.lp2p.thor.data

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query

@Dao
interface AddressDao {
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertPeer(peer: Address)

    @Query("SELECT * FROM Address ORDER BY RANDOM() LIMIT :limit")
    fun randomPeers(limit: Int): List<Address>

}
