package tech.lp2p.thor.ui

import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.BasicAlertDialog
import androidx.compose.material3.Button
import androidx.compose.material3.Card
import androidx.compose.material3.CardDefaults
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import tech.lp2p.thor.R


@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun ResetDialog(onResetRequest: () -> Unit, onDismissRequest: () -> Unit) {
    BasicAlertDialog(onDismissRequest = { onDismissRequest.invoke() }) {
        Card(
            elevation = CardDefaults.cardElevation(
                defaultElevation = 6.dp
            )
        ) {
            Column(
                modifier = Modifier
                    .fillMaxWidth()
                    .padding(16.dp),
            ) {
                Text(
                    text = stringResource(R.string.warning),
                    style = MaterialTheme.typography.titleLarge,
                    textAlign = TextAlign.Center,
                    modifier = Modifier.fillMaxWidth()
                )
                Text(
                    text = stringResource(R.string.browser_cleanup_message),
                    style = MaterialTheme.typography.bodyMedium,
                    textAlign = TextAlign.Start,
                    modifier = Modifier
                        .padding(16.dp)
                        .fillMaxWidth()
                )
                Row(
                    modifier = Modifier
                        .fillMaxWidth()
                        .padding(16.dp, 0.dp)
                ) {
                    Button(onClick = { onDismissRequest.invoke() }) {
                        Text(
                            text = stringResource(android.R.string.cancel),
                        )
                    }
                    Box(modifier = Modifier.weight(1.0f, true))
                    Button(onClick = {
                        onResetRequest.invoke()
                        onDismissRequest.invoke()
                    }
                    ) {
                        Text(
                            text = stringResource(android.R.string.ok),
                        )
                    }
                }
            }
        }
    }
}
