package tech.lp2p.thor

import android.app.Application
import android.util.Log
import android.webkit.CookieManager
import tech.lp2p.thor.model.initializeAds
import tech.lp2p.thor.model.initializePlatform

class App : Application() {

    override fun onCreate() {
        super.onCreate()

        CookieManager.getInstance().setAcceptCookie(false)

        try {
            initializePlatform(applicationContext)
            initializeAds(applicationContext)
        } catch (throwable: Throwable) {
            debug("App", throwable)
        }
    }
}


@Suppress("SameReturnValue")
private val isDebug: Boolean get() = false

@Suppress("SameReturnValue")
private val isError: Boolean get() = true

fun debug(tag: String, message: String) {
    if (isDebug) {
        Log.e(tag, message)
    }
}

fun debug(tag: String, throwable: Throwable) {
    if (isError) {
        Log.e(tag, throwable.localizedMessage, throwable)
    }
}