package tech.lp2p.thor

import androidx.test.ext.junit.runners.AndroidJUnit4
import androidx.test.platform.app.InstrumentationRegistry
import org.junit.Assert.assertEquals
import org.junit.Assert.assertFalse
import org.junit.Assert.assertTrue
import org.junit.Test
import org.junit.runner.RunWith
import tech.lp2p.thor.model.initializeAds
import tech.lp2p.thor.model.isAdHost
import kotlin.system.measureTimeMillis

/**
 * Instrumented test, which will execute on an Android device.
 *
 * See [testing documentation](http://d.android.com/tools/testing).
 */
@RunWith(AndroidJUnit4::class)
class ThorInstrumentedTest {
    @Test
    fun testAds() {
        // Context of the app under test.
        val appContext = InstrumentationRegistry.getInstrumentation().targetContext
        assertEquals("threads.thor", appContext.packageName)


        val time = measureTimeMillis {

            initializeAds(appContext)


            assertFalse(isAdHost("test.abc"))

            assertTrue(isAdHost("2mdn.net"))
        }

        println("Time $time")


    }
}