package tech.lp2p.odin.ui

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.verticalScroll
import androidx.compose.material3.BasicAlertDialog
import androidx.compose.material3.Card
import androidx.compose.material3.CardDefaults
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.LinkAnnotation
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.TextLinkStyles
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.text.withLink
import androidx.compose.ui.unit.dp
import io.github.alexzhirkevich.qrose.rememberQrCodePainter
import tech.lp2p.odin.R

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun InfoDialog(
    uri: String,
    onDismissRequest: () -> Unit
) {

    BasicAlertDialog(onDismissRequest = { onDismissRequest.invoke() }) {
        Card(
            elevation = CardDefaults.cardElevation(
                defaultElevation = 6.dp
            )
        ) {
            Column(
                modifier = Modifier
                    .padding(8.dp)
                    .verticalScroll(rememberScrollState())
            ) {

                Spacer(modifier = Modifier.padding(8.dp))

                Text(
                    text = stringResource(R.string.information),
                    style = MaterialTheme.typography.titleLarge,
                    textAlign = TextAlign.Center, modifier = Modifier.fillMaxWidth()
                )

                Spacer(modifier = Modifier.padding(8.dp))

                Image(
                    painter = rememberQrCodePainter(uri),
                    contentDescription = stringResource(R.string.uri_qrcode),
                    modifier = Modifier
                        .padding(16.dp)
                        .fillMaxWidth()
                )


                Text(
                    modifier = Modifier.padding(16.dp),
                    text = buildAnnotatedString {
                        withLink(
                            LinkAnnotation.Url(
                                uri,
                                TextLinkStyles(style = SpanStyle(color = Color.Blue))
                            )
                        ) {
                            append(uri)
                        }
                    },
                    style = MaterialTheme.typography.labelMedium,
                    softWrap = true,
                    textAlign = TextAlign.Start
                )
            }

            Spacer(modifier = Modifier.padding(8.dp))

        }
    }

}