package tech.lp2p.odin.ui

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.verticalScroll
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import tech.lp2p.odin.ODIN_PORT
import tech.lp2p.odin.R

@Composable
fun HomeView() {


    Column(
        modifier = Modifier
            .padding(0.dp, 0.dp, 0.dp, 32.dp)
            .verticalScroll(rememberScrollState())
    ) {
        Text(
            text = stringResource(R.string.documentation),
            style = MaterialTheme.typography.titleLarge,
            textAlign = TextAlign.Center, modifier = Modifier.fillMaxWidth()
        )

        Spacer(modifier = Modifier.padding(8.dp))

        Text(
            text = stringResource(R.string.limitation),
            style = MaterialTheme.typography.labelLarge,
            modifier = Modifier.padding(16.dp)
        )

        Text(
            text = stringResource(R.string.port_forwarding),
            style = MaterialTheme.typography.titleMedium,
            softWrap = false,
            textAlign = TextAlign.Center,
            modifier = Modifier.fillMaxWidth()
        )

        Text(
            text = stringResource(R.string.port_forwarding_info),
            style = MaterialTheme.typography.labelLarge,
            modifier = Modifier.padding(16.dp)
        )

        Row(modifier = Modifier.padding(8.dp)) {
            Text(
                text = stringResource(R.string.ipv),
                style = MaterialTheme.typography.labelLarge,
                softWrap = false,
                textAlign = TextAlign.Start,
                modifier = Modifier
                    .weight(1.0f, true)
                    .align(Alignment.CenterVertically)
                    .padding(32.dp, 0.dp, 0.dp, 0.dp)
            )
            Text(
                text = "IPv6",
                style = MaterialTheme.typography.labelLarge,
                color = MaterialTheme.colorScheme.primary,
                softWrap = false,
                textAlign = TextAlign.End,
                modifier = Modifier
                    .align(Alignment.CenterVertically)
                    .padding(0.dp, 0.dp, 32.dp, 0.dp)
            )
        }

        Row(modifier = Modifier.padding(8.dp)) {
            Text(
                text = stringResource(R.string.port),
                style = MaterialTheme.typography.labelLarge,
                softWrap = false,
                textAlign = TextAlign.Start,
                modifier = Modifier
                    .weight(1.0f, true)
                    .align(Alignment.CenterVertically)
                    .padding(32.dp, 0.dp, 0.dp, 0.dp)
            )
            Text(
                text = ODIN_PORT.toString(),
                style = MaterialTheme.typography.labelLarge,
                color = MaterialTheme.colorScheme.primary,
                softWrap = false,
                textAlign = TextAlign.End,
                modifier = Modifier
                    .align(Alignment.CenterVertically)
                    .padding(0.dp, 0.dp, 32.dp, 0.dp)
            )
        }

        Row(modifier = Modifier.padding(8.dp)) {
            Text(
                text = stringResource(R.string.protocol),
                style = MaterialTheme.typography.labelLarge,
                softWrap = false,
                textAlign = TextAlign.Start,
                modifier = Modifier
                    .weight(1.0f, true)
                    .align(Alignment.CenterVertically)
                    .padding(32.dp, 0.dp, 0.dp, 0.dp)
            )
            Text(
                text = "TCP",
                style = MaterialTheme.typography.labelLarge,
                color = MaterialTheme.colorScheme.primary,
                softWrap = false,
                textAlign = TextAlign.End,
                modifier = Modifier
                    .align(Alignment.CenterVertically)
                    .padding(0.dp, 0.dp, 32.dp, 0.dp)
            )
        }
        Row(modifier = Modifier.padding(8.dp)) {
            Text(
                text = stringResource(R.string.application),
                style = MaterialTheme.typography.labelLarge,
                softWrap = false,
                textAlign = TextAlign.Start,
                modifier = Modifier
                    .weight(1.0f, true)
                    .align(Alignment.CenterVertically)
                    .padding(32.dp, 0.dp, 0.dp, 0.dp)
            )
            Text(
                text = stringResource(R.string.app_name),
                style = MaterialTheme.typography.labelLarge,
                color = MaterialTheme.colorScheme.primary,
                softWrap = false,
                textAlign = TextAlign.End,
                modifier = Modifier
                    .align(Alignment.CenterVertically)
                    .padding(0.dp, 0.dp, 32.dp, 0.dp)
            )
        }
    }

    Spacer(modifier = Modifier.padding(32.dp))

}