package tech.lp2p.odin.data

import androidx.room.Database
import androidx.room.RoomDatabase
import kotlinx.coroutines.flow.Flow


@Database(entities = [Task::class], version = 1, exportSchema = false)
abstract class Tasks : RoomDatabase() {
    abstract fun tasksDao(): TasksDao

    fun active(): Flow<Boolean> {
        return tasksDao().active()
    }

    suspend fun progress(id: Long, progress: Float) {
        tasksDao().progress(id, progress)
    }

    suspend fun inactive(id: Long) {
        tasksDao().inactive(id)
    }

    suspend fun inactive() {
        tasksDao().inactive()
    }

    suspend fun active(id: Long) {
        tasksDao().active(id)
    }

    suspend fun task(id: Long): Task {
        return tasksDao().task(id)
    }

    suspend fun work(id: Long, work: String) {
        tasksDao().work(id, work)
    }

    suspend fun purge() {
        tasksDao().purge()
    }

    suspend fun finished(id: Long, uri: String) {
        tasksDao().finished(id, uri)
    }

    fun tasks(): Flow<List<Task>> {
        return tasksDao().tasks()
    }

    suspend fun insert(task: Task): Long {
        return tasksDao().insert(task)
    }

    suspend fun delete(task: Task) {
        tasksDao().delete(task)
    }

}
