package tech.lp2p.odin.data

import androidx.room.Entity
import androidx.room.PrimaryKey
import io.github.remmerw.borr.PeerId

@Entity
data class FileInfo(
    @field:PrimaryKey(autoGenerate = true) val cid: Long,
    val uri: String,
    val name: String,
    val mimeType: String,
    val size: Long
) {
    fun pnsUri(peerId: PeerId): String {
        return io.github.remmerw.idun.pnsUri(peerId, cid, name, mimeType, size)
    }
}