package tech.lp2p.odin.data

import androidx.room.Database
import androidx.room.RoomDatabase
import io.github.remmerw.nott.Store
import tech.lp2p.odin.debug
import java.net.InetSocketAddress
import kotlin.random.Random

@Database(entities = [Address::class], version = 1, exportSchema = false)
abstract class Addresses : RoomDatabase(), Store {
    abstract fun addressDao(): AddressDao

    override suspend fun addresses(limit: Int): List<InetSocketAddress> {
        val result = mutableListOf<InetSocketAddress>()
        val peers = addressDao().randomPeers(limit)
        peers.forEach { peer ->
            try {
                result.add(peer.address())
            } catch (throwable: Throwable) {
                debug("Addresses", throwable)
            }
        }
        return result
    }

    override suspend fun store(address: InetSocketAddress) {

        val index = Random.nextInt(0, 100)
        addressDao().insertPeer(
            Address(
                index,
                address.address.address, address.port
            )
        )
    }
}
