package tech.lp2p.odin.ui

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.verticalScroll
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Share
import androidx.compose.material3.BasicAlertDialog
import androidx.compose.material3.Card
import androidx.compose.material3.CardDefaults
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.FloatingActionButton
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import io.github.alexzhirkevich.qrose.rememberQrCodePainter
import tech.lp2p.odin.R
import tech.lp2p.odin.platform

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun InfoDialog(
    uri: String,
    onDismissRequest: () -> Unit,
    onWarningRequest: (String) -> Unit = {}
) {

    BasicAlertDialog(onDismissRequest = { onDismissRequest.invoke() }) {
        Card(
            elevation = CardDefaults.cardElevation(
                defaultElevation = 6.dp
            )
        ) {
            Column(
                modifier = Modifier
                    .padding(8.dp)
                    .verticalScroll(rememberScrollState())
            ) {

                Spacer(modifier = Modifier.padding(8.dp))

                Text(
                    text = stringResource(R.string.information),
                    style = MaterialTheme.typography.titleLarge,
                    textAlign = TextAlign.Center, modifier = Modifier.fillMaxWidth()
                )

                Spacer(modifier = Modifier.padding(8.dp))

                Image(
                    painter = rememberQrCodePainter(uri),
                    contentDescription = stringResource(R.string.uri_qrcode),
                    modifier = Modifier
                        .padding(16.dp)
                        .fillMaxWidth()
                )

                Row(
                    modifier = Modifier.padding(8.dp),
                    horizontalArrangement = Arrangement.SpaceEvenly,
                    verticalAlignment = Alignment.CenterVertically
                ) {

                    Text(
                        text = uri,
                        style = MaterialTheme.typography.labelMedium,
                        softWrap = true,
                        textAlign = TextAlign.Start,
                        modifier = Modifier.weight(1.0f, true)
                    )
                    FloatingActionButton(
                        modifier = Modifier.padding(8.dp),
                        onClick = {
                            onDismissRequest.invoke()
                            platform().sharePageUri(uri, onWarningRequest)
                        }) {
                        Icon(
                            imageVector = Icons.Default.Share,
                            contentDescription = stringResource(R.string.share)
                        )
                    }
                }

                Spacer(modifier = Modifier.padding(8.dp))
            }
        }
    }

}