package tech.lp2p.odin.model

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.HelpOutline
import androidx.compose.material.icons.filled.Apps
import androidx.compose.material.icons.filled.Dataset
import androidx.compose.material.icons.filled.Fingerprint
import androidx.compose.material.icons.filled.Folder
import androidx.compose.material.icons.filled.PictureAsPdf
import androidx.compose.material.icons.outlined.Abc
import androidx.compose.material.icons.outlined.AudioFile
import androidx.compose.material.icons.outlined.Html
import androidx.compose.material.icons.outlined.Image
import androidx.compose.material.icons.outlined.VideoFile
import androidx.compose.ui.graphics.vector.ImageVector

internal fun mediaResource(mimeType: String): ImageVector {
    if (mimeType.isNotEmpty()) {
        if (mimeType == "application/x-bittorrent") {
            return Icons.Default.Fingerprint
        }
        if (mimeType == "application/octet-stream") {
            return Icons.Default.Dataset
        }
        if (mimeType == "text/html") {
            return Icons.Outlined.Html
        }
        if (mimeType == "application/pdf") {
            return Icons.Default.PictureAsPdf
        }
        if (mimeType == "vnd.android.document/directory") {
            return Icons.Filled.Folder
        }
        if (mimeType.startsWith("text/")) {
            return Icons.Outlined.Abc
        }
        if (mimeType.startsWith("video/")) {
            return Icons.Outlined.VideoFile
        }
        if (mimeType.startsWith("image/")) {
            return Icons.Outlined.Image
        }
        if (mimeType.startsWith("audio/")) {
            return Icons.Outlined.AudioFile
        }
        if (mimeType.startsWith("application/")) {
            return Icons.Default.Apps
        }
    }

    return Icons.AutoMirrored.Default.HelpOutline
}