package tech.lp2p.odin.data

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import kotlinx.coroutines.flow.Flow

@Dao
interface FilesDao {
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertFileInfo(fileInfo: FileInfo): Long

    @Delete
    suspend fun delete(fileInfo: FileInfo)

    @Query("SELECT * FROM FileInfo ORDER BY cid DESC")
    fun flowFileInfos(): Flow<List<FileInfo>>

    @Query("SELECT * FROM FileInfo WHERE cid = :cid")
    suspend fun fileInfo(cid: Long): FileInfo?

    @Query("SELECT name FROM FileInfo")
    suspend fun names(): List<String>

}
