import java.io.FileInputStream
import java.util.Properties


plugins {
    alias(libs.plugins.android.application)
    alias(libs.plugins.kotlin.android)
    alias(libs.plugins.kotlin.compose)
    alias(libs.plugins.ksp)
}


val keystoreProperties = Properties()
val keystorePropertiesFile = rootProject.file("release-keystore.properties")
if (keystorePropertiesFile.exists()) {
    keystoreProperties.load(FileInputStream(keystorePropertiesFile))
}


dependencies {
    // Android (LICENSE done)
    implementation(libs.androidx.room.runtime)

    // Android (LICENSE done)
    implementation(libs.androidx.datastore.preferences.core)
    // Android (LICENSE done)
    implementation(libs.androidx.datastore.preferences)

    // Kotlin (LICENSE done)
    implementation(libs.kotlin.stdlib)
    // Kotlin (LICENSE done)
    implementation(libs.kotlinx.io.core)

    // Android (LICENSE done)
    implementation(libs.androidx.work.runtime)
    // Android (LICENSE done)
    implementation(libs.androidx.activity.compose)

    // Compose (LICENSE done)
    implementation(platform(libs.androidx.compose.bom))
    // Compose Lib (LICENSE done)
    implementation(libs.androidx.material.icons.core)
    // Compose Lib (LICENSE done)
    implementation(libs.androidx.material.icons.extended)
    // Compose Lib (LICENSE done)
    implementation(libs.androidx.material3.window.size.class1)
    // Compose Lib (LICENSE done)
    implementation(libs.androidx.material3)
    // Compose Lib (LICENSE done)
    implementation(libs.androidx.ui)
    // Compose Lib (LICENSE done)
    implementation(libs.androidx.lifecycle.viewmodel.compose)

    // API (LICENSE done)
    implementation(libs.uri.kmp)
    // API (LICENSE done)
    implementation(libs.qrose)
    // API (LICENSE done)
    implementation(libs.filekit.core)
    // API (LICENSE done)
    implementation(libs.filekit.dialogs.compose)


    // API (LICENSE done)
    implementation(libs.nott)
    // API (LICENSE done)
    implementation(libs.idun)
    // API (LICENSE done)
    implementation(libs.dagr)
    // API (LICENSE done)
    implementation(libs.borr)


    // Android (LICENSE done)
    ksp(libs.androidx.room.compiler)


    // Testing
    testImplementation(libs.junit)
    androidTestImplementation(libs.androidx.junit)
    androidTestImplementation(libs.androidx.espresso.core)
    androidTestImplementation(platform(libs.androidx.compose.bom))
    androidTestImplementation(libs.androidx.ui.test.junit4)
}



android {
    compileSdk = 36
    namespace = "tech.lp2p.odin"


    defaultConfig {
        applicationId = "threads.server"
        minSdk = 29
        targetSdk = 36
        versionCode = 357
        versionName = "3.5.7"

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
    }

    buildTypes {
        debug {
            isMinifyEnabled = false
            isShrinkResources = false
        }
        release {
            isMinifyEnabled = true
            isShrinkResources = true

        }
    }

    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_21
        targetCompatibility = JavaVersion.VERSION_21
    }


    buildFeatures {
        compose = true
    }

}
