<img src="fastlane/metadata/android/en-US/images/icon.png" width="85"/>

# Plexus-app
***Remove the fear of Android app compatibility on de-Googled devices.***

Android app for [Plexus](https://plexus.techlore.tech)

<img src="https://img.shields.io/f-droid/v/tech.techlore.plexus?logo=FDroid&color=green&style=for-the-badge" alt="F-Droid Version"> <img src="https://img.shields.io/endpoint?url=https://apt.izzysoft.de/fdroid/api/v1/shield/tech.techlore.plexus&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAMAAABg3Am1AAAA4VBMVEXn9cuv7wDB9iGp4x2k5gKh3B6k3SyAxAGd4ASo6gCv5SCW2gHA7UTB6V+EwiOw3lK36zC+422d1yO78SWs3kfR7JhQiw2751G7+QCz8gCKzgGq3zay5DSm2jrF9jZLfwmNyiC77zXO7oaYzjW37CLj9Lze8LLA43uz3mK19ACR1QBcnRO78R6ExBek1kbE8FLI6nSPu0jH5YJxtQ2b1RiAmz53uwF7pitZkAeX1w7I72TY8KTO8HXD7La+0pKizWBzhExqjytpmR+UzSTA5Ctzy3uv1nOv3gyF3UuCsDRHcEx7M2pHAAAAS3RSTlP//////////////////////////////////////////////////////////////////////////////////////////////////wDLGfCsAAAB9ElEQVRIx72W53biMBCFhY0L7g0bTAktQEwgdMhuerbO+z/Q2sBiY0uKcvacnX8a3Y/R8YyuQPDJQP8KoExcro6ZC6C4TQXQx/oLABV3cfozgBgL/AWY9ScAsR7oBCD2AmSAoD8A+J3cWYECdBEaVm2z+U1hAuDx4fr6a08PGuuf6cmys5QvMEz0c12zhPWaAYBq9emp9/DlTrMUXsBOaw5Yjl5elrG+u9tYAxbAtjeL+Z3Wdl83Ovfr3BQyYAZBoLXbHDfQ2hykTSEAAIu+2LRcl4tD6UCm67jPCvD4/ON5YRhGpzOdrlar74fT5IcvOxDD0Xg0nvU7hjGVttv+0vYyAgyQdNgeey3Hce5DSZqN9GZmvzh8UO0F3thsiY4gqGoUtuL2AeaKpom5brVMryEKvCyXZVX0urd0wOxy4qwh8jxfLlcqZafpYoH0MzQGnNI/6CulOASFc/NWlZ17ADEG3oWjvn5TEvjbfJuyrnFaSfdyrK/f1Gp1tTAHF750aqgUJUCsr5UizFUv3EeQwmOFekmVmABDCiNVlqNwOwEqcM75vp+s/asrKpAmdxM/Gbnfuz0j8OYnPw2v9AqZ5Nt+f7hikwkw2T3Fc2l2jzdcst3DpwGCnvQ+EPUEu8c/STSAqMfZPeX5IQK0J+a//zn5MP4Am7ISN/4mSV8AAAAASUVORK5CYII=&color=3BCCFF&label=IzzyOnDroid&style=for-the-badge" alt="IzzyOnDroid Version"> <img src="https://img.shields.io/github/v/release/techlore/Plexus-app?logo=GitHub&label=GitHub&color=212121&style=for-the-badge" alt="GitHub Version">


## Contents
- [Overview](#overview)
- [Help & FAQs](#help--faqs)
- [Screenshots](#screenshots)
- [Download](#download)
- [Changelog](#changelog)
- [Privacy policy](#privacy-policy)
- [Issues](#issues)
- [Contributing](#contributing)
- [Credits](#credits)
- [License](#license)


## Overview
Google Play Services are essential components on most Android devices. They allow you to access your Google account seamlessly and provide Google-specific features for apps that depend on them.
<br>However, when you flash custom ROMs without Google Play Services or opt for alternatives like [microG](https://microg.org/), certain apps may encounter issues — either not functioning at all or experiencing limitations in specific features.

Plexus provides detailed insights into app compatibility whether you’re using ROMs without Google Play Services (like _LineageOS_) or ROMs with microG (such as _CalyxOS_). It helps you identify which apps work, don’t work or have limited features.
<br>All the information is crowdsourced by the community, for the community.


## Help & FAQs
- Visit the [Help page](https://github.com/techlore/Plexus-app/wiki/Help) to familiarize yourself with the all the indicators in the app & know how to submit ratings.
- Visit the [FAQs page](https://github.com/techlore/Plexus-app/wiki/FAQs) for answers to common questions.


## Screenshots
<img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/1.png" width="200"/>  <img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/2.png" width="200"/>

<img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/3.png" width="200"/>  <img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/4.png" width="200"/>


## Download
Reproducible builds are enabled, allowing you to install and upgrade the app from any of the following sources, interchangeably:

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
alt="Get it on F-Droid"
height="80">](https://f-droid.org/packages/tech.techlore.plexus)
[<img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png"
alt="Get it on IzzyOnDroid"
height="80">](https://apt.izzysoft.de/fdroid/index/apk/tech.techlore.plexus)
[<img src="https://raw.githubusercontent.com/Kunzisoft/Github-badge/main/get-it-on-github.png"
alt="Get it on GitHub"
height="80">](https://github.com/techlore/Plexus-app/releases/latest)

### Verify integrity if downloaded from GitHub
To verify the integrity of the `.apk`/`.aab` files, if downloaded from GitHub, perform the following steps:

<details>
  <summary><b>Windows</b></summary>

1. Open Powershell by searching for it in the `Start menu` OR by pressing `Win + r` and typing `powershell`
2. Change directory to the downloaded path
   ```
   cd "C:\path\to\downloaded\file"
   ```
   Example:
   ```
   cd "C:\Users\JohnDoe\Downloads"
   ```
3. Compute the SHA-256 Hash
   ```
   Get-FileHash -Algorithm SHA256 -Path "filename"
   ```
   Example:
   ```
   Get-FileHash -Algorithm SHA256 -Path "Plexus_v2.0.0.apk"
   ```
4. The computed hash value should be exactly the same as the one provided in the `.sha256` file on GitHub.
</details>

<details>
  <summary><b>Linux & macOS</b></summary>

1. Open terminal
2. Change directory to the downloaded path
   ```
   cd /path/to/downloaded/file
   ```
   Example:
   ```
   cd /home/JohnDoe/Downloads/
   ```
3. Compute the SHA-256 Hash
   ```
   sha256sum filename
   ```
   Example:
   ```
   sha256sum Plexus_v2.0.0.apk
   ```
4. The computed hash value should be exactly the same as the one provided in the `.sha256` file on GitHub.
</details>


## Changelog
All notable changes to this project will be documented in the [changelog](https://github.com/techlore/Plexus-app/blob/main/CHANGELOG.md).


## Privacy policy
Privacy policy is located [here](https://github.com/techlore/Plexus-app/blob/main/PRIVACY.md).


## Issues
If you find bugs or have suggestions, please report it to the [issue tracker](https://github.com/techlore/Plexus-app/issues).
- Make sure you're on the latest version before reporting any issues.
- We encourage you to search for existing issues before opening a new one. Any duplicates will be closed.


## Contributing
Please read the [contributing guidelines](https://github.com/techlore/Plexus-app/blob/main/CONTRIBUTING.md) before contributing.

New pull requests can be submitted [here](https://github.com/techlore/Plexus-app/pulls).


## Credits
- [StellarSand](https://github.com/StellarSand) for developing this app.
- [parveshnarwal](https://github.com/parveshnarwal) for helping previously with the initial implementation of json into this app.
- [tomkonidas](https://github.com/tomkonidas) for developing the API & the Plexus website which helped in the development of this project.
- [Henry](https://github.com/henry-fisher) for going forward with the project and designing/modifying some of the icons.
- [Contributors](https://github.com/techlore/plexus-app/graphs/contributors) for making this app better.
- Everyone who has and continues to contribute data to make this project better than ever.


## License
This project is licensed under the terms of [GPL v3.0 license](https://github.com/techlore/Plexus-app/blob/main/LICENSE).
