// SPDX-License-Identifier: GPL-3.0-only

import 'sql_schema_logic.dart';

/// Contains info relating to a specific SQL query, and the schema version of the database we're reading from ([fromSchemaVersion]) and/or writing to ([toSchemaVersion]). Also has a plain English [description] which is used in user-facing scenarios eg error messages.
class TransactionSchemaDetails {
  final SchemaVersion? toSchemaVersion;
  final SchemaVersion? fromSchemaVersion;
  final String description;

  TransactionSchemaDetails({
    this.toSchemaVersion,
    this.fromSchemaVersion,
    required this.description,
  });
}
