// SPDX-License-Identifier: GPL-3.0-only

import 'package:flutter/material.dart';
import 'package:url_launcher/url_launcher.dart';

import 'app_state.dart';
import 'constants.dart';

/// A table cell specialised for showing a URL.
class TableCellUrl extends StatelessWidget {
  final dynamic value;
  final Map<String, dynamic> cellLayout;

  const TableCellUrl({
    super.key,
    required this.value,
    this.cellLayout = BS.tableCellLayoutStandard,
  });

  @override
  Widget build(BuildContext context) {
    late final Uri uri = Uri.parse(value);
    bool shortenUrlsForDisplay = AppState.getPreference('shortenUrlsForDisplay');

    return Padding(
      padding: cellLayout['padding'],
      child: Material(
        type: MaterialType.transparency,
        child: Tooltip(
          message: 'Open $value',
          child: ElevatedButton(
            style: ElevatedButton.styleFrom(
              shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(BS.cornerRadius)),
              visualDensity: VisualDensity.compact,
              padding: cellLayout['urlButtonPadding'],
            ),
            onPressed: () {
              AppState.debounceVoidFunction(
                callerKey: UniqueKey().toString(),
                debounceDuration: BS.openYouTubeDebounceDuration,
                voidFunction: () async {
                  AppState.debug(uri.toString());
                  if (!await launchUrl(uri)) {
                    throw Exception(value);
                  }
                },
              );
            },
            child: Text(
              '${shortenUrlsForDisplay ? '' : uri.authority}${uri.path}/${uri.query}',
              style: cellLayout['textStyle'],
            ),
          ),
        ),
      ),
    );
  }
}
