// SPDX-License-Identifier: GPL-3.0-only

import 'enum.dart';

/// Static functions to return strings for use in SQL queries.
class SqlStringMaker {
  static String streamColumnsWithQuotesAndCommas =
      StreamColumns.values.map((e) => "'${e.name}'").toList().join(', ');

  static String streamColumnsUnspecifiedParams =
      StreamColumns.values.map((e) => '?').toList().join(', ');
}
