// SPDX-License-Identifier: GPL-3.0-only

import 'package:flutter/material.dart';

import 'constants.dart';
import 'enum.dart';
import 'playlist_icon_and_item_count.dart';
import 'standard_table_title.dart';

/// Header for a playlist.
///
/// Containing:
/// - The playlist name, in an editable [TextField]
/// - Playlist-specific buttons
class SimplePlaylistHeaderWidget extends StatelessWidget {
  final String name;
  final int itemCount;
  final TableType tableType;

  const SimplePlaylistHeaderWidget({
    super.key,
    required this.name,
    required this.itemCount,
    required this.tableType,
  });

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.only(right: BS.paddingMedium),
      child: Row(
        mainAxisSize: MainAxisSize.min,
        spacing: BS.paddingMedium,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          SizedBox(
            height: BS.playlistHeaderTopRowHeight,
            child: PlaylistIconAndItemCount(
              tableType: tableType,
              label: itemCount.toString(),
            ),
          ),
          Expanded(child: StandardTableTitle(name)),
        ],
      ),
    );
  }
}
