// SPDX-License-Identifier: GPL-3.0-only

import 'package:flutter/material.dart';

import 'constants.dart';

class SectionHeadingWidget extends StatelessWidget {
  const SectionHeadingWidget(
    this.text, {
    super.key,
  });

  final String text;

  @override
  Widget build(BuildContext context) {
    return Center(
      child: Padding(
        padding: EdgeInsets.only(
          right: BS.paddingMedium,
          left: BS.paddingSmall,
          bottom: BS.paddingMedium,
          top: BS.paddingLarge,
        ),
        child: Text(
          text,
          style: TextStyle(
            fontSize: BS.fontSizeHeading,
            fontWeight: FontWeight.bold,
            color: Theme.of(context).colorScheme.secondary,
          ),
        ),
      ),
    );
  }
}
