// SPDX-License-Identifier: GPL-3.0-only

import 'package:flutter/material.dart';

import 'constants.dart';
import 'enum.dart';

/// An icon indicating the type of playlist, and a number indicating how many
/// items it contains.
class PlaylistIconAndItemCount extends StatelessWidget {
  const PlaylistIconAndItemCount({
    super.key,
    required this.tableType,
    required this.label,
    this.searchIsInProgress = false,
  });

  final TableType tableType;
  final String label;
  final bool searchIsInProgress;

  @override
  Widget build(BuildContext context) {
    TextStyle textStyle = TextStyle(
      height: 1,
      leadingDistribution: TextLeadingDistribution.even,
      fontSize: BS.fontSizePlaylistItemCount,
    );

    return Padding(
      padding: const EdgeInsets.only(top: BS.paddingExtraSmall),
      child: Row(
          crossAxisAlignment: CrossAxisAlignment.center,
          mainAxisSize: MainAxisSize.min,
          children: [
            Flexible(
                child: Padding(
              padding: const EdgeInsets.only(right: BS.paddingSmall),
              child: SizedBox(
                  width: BS.playlistItemCountWidth,
                  child: Align(
                      alignment: Alignment.centerRight,
                      child: searchIsInProgress
                          ? Text(
                              '..?',
                              style: textStyle.copyWith(
                                color: Theme.of(context)
                                    .colorScheme
                                    .onSurface
                                    .withValues(alpha: BS.tappableMildOpacity),
                              ),
                            )
                          : Text(
                              label,
                              style: textStyle,
                            ))),
            )),
            Flexible(
              child: switch (tableType) {
                TableType.remotePlaylists => Icon(
                    Icons.video_library_rounded,
                  ),
                TableType.subscriptions => Icon(
                    Icons.recent_actors_rounded,
                  ),
                TableType.localPlaylist => Icon(
                    Icons.list,
                  ),
                TableType.search => Icon(
                    Icons.list,
                  ),
              },
            ),
          ]),
    );
  }
}
