// SPDX-License-Identifier: GPL-3.0-only

import 'package:flutter/material.dart';

import 'constants.dart';

/// Display a number in an icon-type format.
class InfoItemNumberIcon extends StatelessWidget {
  const InfoItemNumberIcon({
    super.key,
    required this.itemNumberLabel,
  });

  final String itemNumberLabel;

  @override
  Widget build(BuildContext context) {
    ColorScheme colorScheme = Theme.of(context).colorScheme;
    return SizedBox(
      width: BS.numberIconSize,
      height: BS.numberIconSize,
      child: Stack(
        children: [
          Positioned.fill(
            child: ColoredBox(
              color: colorScheme.primaryContainer,
            ),
          ),
          Positioned.fill(
            child: ClipOval(
              child: ColoredBox(
                color: Color.alphaBlend(
                    colorScheme.onSurface.withValues(alpha: 0.7), colorScheme.primaryContainer),
              ),
            ),
          ),
          Positioned.fill(
            child: Center(
              child: Text(
                itemNumberLabel,
                style: TextStyle(
                  color: colorScheme.primaryContainer,
                  fontWeight: FontWeight.bold,
                  fontSize: BS.fontSizeNumberIcon,
                ),
              ),
            ),
          ),
        ],
      ),
    );
  }
}
