// SPDX-License-Identifier: GPL-3.0-only

import 'package:flutter/material.dart';

import 'app_state.dart';
import 'bs_database.dart';

class Databases with ChangeNotifier {
  final Map<String, BsDatabase> _databases = {};

  void add({required String key, required BsDatabase database}) {
    AppState.debug('Databases::add()');
    if (!_databases.containsKey(key)) {
      _databases[key] = database;
      notifyListeners();
    }
  }

  bool remove(String dbPath, {suppressNotifications = false}) {
    AppState.debug('Databases::remove()');
    bool didRemove = false;
    if (_databases.containsKey(dbPath)) {
      _databases.remove(dbPath);
      didRemove = true;
      notifyListeners();
    }
    return didRemove;
  }

  void removeAll() {
    AppState.debug('Databases::removeAll()');

    /// Operate on a copy so we don't remove items from the list we're looping through
    for (String dbPath in List.of(_databases.keys)) {
      if (remove(dbPath, suppressNotifications: true)) {
        AppState.debug('Removed DB $dbPath');
      }
    }
    notifyListeners();
  }

  BsDatabase? getByKey(String key) {
    return _databases[key];
  }

  bool containsKey(String key) {
    return _databases.containsKey(key);
  }

  int get length {
    return _databases.length;
  }

  bool get isEmpty {
    return _databases.isEmpty;
  }

  bool get isNotEmpty {
    return _databases.isNotEmpty;
  }

  List<String> get keys {
    return _databases.keys.toList();
  }
}
