// SPDX-License-Identifier: GPL-3.0-only

import 'package:flutter/material.dart';

import 'app_state.dart';
import 'constants.dart';
import 'db_manager.dart';
import 'enum.dart';
import 'screen.dart';
import 'sql_schema_logic.dart';

class DatabaseInfoWidget extends StatelessWidget {
  const DatabaseInfoWidget({
    super.key,
    required this.dbPath,
    this.backgroundColor = Colors.grey,
  });

  final String dbPath;
  final Color backgroundColor;

  @override
  Widget build(BuildContext context) {
    ColorScheme colorScheme = Theme.of(context).colorScheme;
    TextStyle labelStyle = TextStyle(
        color: Color.alphaBlend(
            colorScheme.secondary.withValues(alpha: BS.tappableMildOpacity), backgroundColor));
    TextStyle infoStyle = labelStyle;
    //TextStyle infoStyle = TextStyle(
    //  color: Color.alphaBlend(
    //      Color.alphaBlend(colorScheme.tertiary.withValues(alpha: 0.666), colorScheme.secondary)
    //          .withValues(alpha: 0.8),
    //      backgroundColor),
    //);
    SchemaVersion schemaVersion = DbManager.getSchemaVersion(dbPath);
    Map<String, String> rows = {
      'file name': DbManager.databases.getByKey(dbPath)?.prettyName ?? '',
    };
    if (AppState.getPreference('dbInfoToShow') == DbInfoToShow.extended.name) {
      rows.addAll({
        'file path': DbManager.databases.getByKey(dbPath)?.originalZipPath ?? '',
        'database schema': "'${schemaVersion.name}': ${schemaVersion.description}",
      });
    }

    return DecoratedBox(
      decoration: BoxDecoration(
        color: backgroundColor,
        borderRadius: const BorderRadius.only(
          bottomRight: Radius.circular(BS.cornerButtonRadius),
        ),
      ),
      child: Padding(
        padding: EdgeInsets.only(
          right: BS.paddingMedium,
          bottom: BS.paddingSmall,
          top: BS.paddingSmall + BS.paddingExtraSmall,
        ),
        child: Table(
          columnWidths: {
            0: FixedColumnWidth(Screen.isCompact(context)
                ? BS.infoTableLabelColumnWidthCompact
                : BS.infoTableLabelColumnWidthStandard),
          },
          children: [
            ...rows.entries.map(
              (entry) => TableRow(
                children: [
                  TableCell(
                    child: Padding(
                      padding: const EdgeInsets.only(
                        bottom: BS.paddingMedium,
                        right: BS.paddingMedium,
                        left: BS.paddingMedium,
                      ),
                      child: Text(
                        entry.key,
                        style: labelStyle,
                        textAlign: TextAlign.end,
                      ),
                    ),
                  ),
                  TableCell(
                    child: Padding(
                      padding: const EdgeInsets.only(
                        bottom: BS.paddingMedium,
                        left: BS.paddingSmall + BS.paddingSuperSmall,
                      ),
                      child: Text(
                        entry.value,
                        style: infoStyle,
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }
}
