// SPDX-License-Identifier: GPL-3.0-only

import 'package:flutter/material.dart';

import 'app_state.dart';
import 'constants.dart';
import 'db_manager.dart';
import 'tooltip_icon_button.dart';

class CreatePlaylistButton extends StatelessWidget {
  final String dbPath;

  const CreatePlaylistButton({
    super.key,
    required this.dbPath,
  });

  @override
  Widget build(BuildContext context) {
    return Align(
      alignment: Alignment.center,
      child: Padding(
        padding: const EdgeInsets.only(
          top: BS.paddingExtraLarge,
          bottom: BS.paddingExtraLarge,
        ),
        child: TooltipIconButton(
          text: 'Create new empty playlist',
          iconData: Icons.add,
          layout: TooltipIconButtonLayout.iconOnRight,
          onPressedCallback: _addNewEmptyPlaylist,
        ),
      ),
    );
  }

  void _addNewEmptyPlaylist() {
    DbManager.createNewEmptyLocalPlaylist(dbPath);
    AppState.update(dbPath, DbManager.databases, forceRebuild: true);
  }
}
