// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

library mixin_step_test;

import 'dart:collection';
import 'dart:developer';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/sdk_break_with_mixin_test.dart
//
const LINE_A = 28;
const LINE_B = 32;
// AUTOGENERATED END

int codeRuns = 0;

void code() {
  if (++codeRuns > 1) {
    print('Calling debugger!');
    debugger(); // LINE_A
  }
  final y = MySet();
  // ignore: avoid_function_literals_in_foreach_calls
  y.forEach((element) /* LINE_B */ {
    print(element);
  });
}

class MySet extends Object with SetMixin {
  @override
  bool add(value) => throw UnimplementedError();
  @override
  bool contains(Object? element) => false;
  @override
  Iterator get iterator => [].iterator;
  @override
  int get length => 0;
  @override
  Never lookup(Object? element) => throw UnimplementedError();
  @override
  bool remove(Object? value) => throw UnimplementedError();
  @override
  Set toSet() => throw UnimplementedError();
}

final stops = <String>[];
// THIS TEST DEPENDS ON SPECIFIC LINE NUMBERS IN UNRELATED PLATFORM LIBRARIES
// STAYING FIXED. VERY FRAGILE. SHOULD BE FIXED OR REMOVED.
const SDK_LINE = 142;
const expected = <String>[
  'set.dart:$SDK_LINE:21 (sdk_break_with_mixin_test.dart:$LINE_B:5)',
];

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  markDartColonLibrariesDebuggable,
  setBreakpointAtUriAndLine(
    'org-dartlang-sdk:///sdk/lib/collection/set.dart',
    SDK_LINE,
  ),
  resumeProgramRecordingStops(stops, true),
  checkRecordedStops(stops, expected, debugPrint: true),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'sdk_break_with_mixin_test.dart',
      testeeBefore: code,
      testeeConcurrent: code,
      pauseOnStart: false,
      pauseOnExit: true,
    );
