// Copyright (c) 2021, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:async';
import 'dart:convert';
import 'dart:developer';

import 'package:vm_service/vm_service.dart';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 33;
// AUTOGENERATED END

Future<ServiceExtensionResponse> echo(
  String method,
  Map<String, String> args,
) async {
  print('In service extension');
  return ServiceExtensionResponse.result(json.encode(args));
}

void testMain() {
  registerExtension('ext.foo', echo);
  debugger(); // LINE_A
}

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
  resumeIsolate,
  (VmService vm, IsolateRef isolateRef) async {
    print('waiting for response');
    final response = await vm.callServiceExtension(
      'ext.foo',
      isolateId: isolateRef.id!,
      args: {'foo': 'bar'},
    );
    print('got response');
    print(response.json);
  },
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'regress_46559_test.dart',
      testeeConcurrent: testMain,
    );
