// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:io';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 21;
// AUTOGENERATED END

const file = 'step_through_simple_async_test.dart';

Future<void> code() /* LINE_A */ async {
  final f = File(Platform.script.toFilePath());
  final modified = await f.lastModified();
  final exists = await f.exists();
  print('Modified: $modified; exists: $exists');
  foo();
}

void foo() {
  print('Hello from Foo!');
}

final stops = <String>[];
const expected = <String>[
  '$file:${LINE_A + 0}:18', // on '(' in code()'
  '$file:${LINE_A + 1}:27', // on 'script'
  '$file:${LINE_A + 1}:34', // on 'toFilePath'
  '$file:${LINE_A + 1}:13', // on File
  '$file:${LINE_A + 2}:28', // on 'lastModified'
  '$file:${LINE_A + 2}:20', // on 'await'
  '$file:${LINE_A + 3}:26', // on 'exists'
  '$file:${LINE_A + 3}:18', // on 'await'
  '$file:${LINE_A + 4}:47', // on ')', i.e. before ';'
  '$file:${LINE_A + 4}:3', // on call to 'print'
  '$file:${LINE_A + 5}:3', // on call to 'foo'
  '$file:${LINE_A + 6}:1', // ending '}'
];

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLine(LINE_A),
  runStepThroughProgramRecordingStops(stops),
  checkRecordedStops(stops, expected),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'step_through_simple_async_test.dart',
      testeeConcurrent: code,
      pauseOnStart: true,
      pauseOnExit: true,
    );
