import 'package:flex_color_scheme/flex_color_scheme.dart';
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';

import 'home_page.dart';

// ignore_for_file: unused_import
// ignore_for_file: lines_longer_than_80_chars
// ignore_for_file: unreachable_from_main

// -----------------------------------------------------------------------------
/// EXAMPLE: COPY-PASTE PLAYGROUND
//
// Use this example to via copy-paste test a theme using code generated by
// the Themes PlayGround found at:
// https://rydmike.com/flexcolorscheme/themesplayground-v7-2
// -----------------------------------------------------------------------------
void main() => runApp(const DemoApp());

class DemoApp extends StatefulWidget {
  const DemoApp({super.key});

  @override
  State<DemoApp> createState() => _DemoAppState();
}

class _DemoAppState extends State<DemoApp> {
  ThemeMode themeMode = ThemeMode.system;

  // ignore: unused_field
  late final String? _fontFamily = GoogleFonts.notoSans().fontFamily;
  @override
  Widget build(BuildContext context) {
    // To simulate what the looks like on other platforms if you used platform
    // adaptive themes in FlexColorScheme config, you can uncomment this line,
    // import foundation and set TargetPlatform to desired platform to test.
    //
    // debugDefaultTargetPlatformOverride = TargetPlatform.iOS;

    return MaterialApp(
      debugShowCheckedModeBanner: false,
      title: 'Copy Playground',
      // To use this app with the Flutter SDK default theme and default
      // Material Design 2 color scheme, uncomment and use the theme setup below
      // and comment the copy-pasted themes further below,
      //
      // theme: ThemeData(
      //   colorScheme: const ColorScheme.light(),
      //   typography: Typography.material2018(platform: defaultTargetPlatform),
      // ),
      // darkTheme: ThemeData(
      //   colorScheme: const ColorScheme.dark(),
      //   typography: Typography.material2018(platform: defaultTargetPlatform),
      // ),

      // This is where you would put a copy-pasted theme definition from
      // the Themes Playground. There is already one example below, but do
      // try your own copy-paste new setup code from the
      // Themes Playground app available at:
      // https://rydmike.com/flexcolorscheme/themesplayground-v7
      theme: FlexThemeData.light(
        useMaterial3: true,
        scheme: FlexScheme.redWine,
        blendLevel: 2,
        appBarOpacity: 0.98,
        subThemesData: const FlexSubThemesData(
          inputDecoratorRadius: 8,
          inputDecoratorPrefixIconSchemeColor: SchemeColor.primary,
          inputDecoratorSchemeColor: SchemeColor.primary,
          inputDecoratorBackgroundAlpha: 0x18,
          inputDecoratorUnfocusedHasBorder: false,
          appBarScrolledUnderElevation: 6,
          popupMenuOpacity: 0.96,
          bottomNavigationBarOpacity: 0.96,
          navigationBarOpacity: 0.96,
          navigationRailOpacity: 0.96,
        ),
        visualDensity: FlexColorScheme.comfortablePlatformDensity,
        // Custom fonts to demonstrate you pass a default GoogleFonts TextTheme
        // to both textTheme and primaryTextTheme in M2/M3 mode as well as in
        // light/dark theme and have them get correct default color and
        // contrast color in all cases. Vanilla ThemeData does not do this.
        fontFamily: GoogleFonts.notoSans().fontFamily,
        textTheme: GoogleFonts.notoSansTextTheme(),
        primaryTextTheme: GoogleFonts.notoSansTextTheme(),
      ),
      darkTheme: FlexThemeData.dark(
        useMaterial3: true,
        scheme: FlexScheme.flutterDash,
        blendLevel: 14,
        appBarStyle: FlexAppBarStyle.background,
        appBarOpacity: 0.96,
        subThemesData: const FlexSubThemesData(
          inputDecoratorRadius: 8,
          inputDecoratorPrefixIconSchemeColor: SchemeColor.primary,
          inputDecoratorSchemeColor: SchemeColor.primary,
          inputDecoratorBackgroundAlpha: 0x22,
          inputDecoratorUnfocusedHasBorder: false,
          popupMenuOpacity: 0.96,
          bottomNavigationBarOpacity: 0.96,
          navigationBarOpacity: 0.96,
          navigationRailOpacity: 0.96,
          navigationRailLabelType: NavigationRailLabelType.none,
        ),
        visualDensity: FlexColorScheme.comfortablePlatformDensity,
        fontFamily: GoogleFonts.notoSans().fontFamily,
        // Custom fonts to demonstrate you pass a default GoogleFonts TextTheme
        // to both textTheme and primaryTextTheme in M2/M3 mode as well as in
        // light/dark theme and have them get correct default color and
        // contrast color in all cases. Vanilla ThemeData does not do this.
        textTheme: GoogleFonts.notoSansTextTheme(),
        primaryTextTheme: GoogleFonts.notoSansTextTheme(),
      ),
      themeMode: themeMode,

      // If you want to use ThemeData.from a ColorScheme based on a ColorScheme
      // from FlexColorScheme, then comment the other two theme setups above and
      // uncomment the theme setup below, and copy-paste the generated
      // ColorScheme code from the Themes Playground app at
      // https://rydmike.com/flexcolorscheme/themesplayground-v7-1
      // over the example ColorSchemes further below, with copy-pasted schemes.
      // This will give you the same colors as with FlexColorScheme, but no
      // other theme customizations FlexColorScheme does when it creates
      // its ThemeData with FlexColorScheme.toTheme or using its
      // FlexThemeData extensions and opinionated component themes. You will
      // need to customize ThemeData yourself and adjust all its quirks.
      //
      // This example is to show that it is possible to also only use the light
      // and dark ColorSchemes generated by FlexColorScheme.
      //
      // theme: ThemeData(
      //   useMaterial3: true,
      //   colorScheme: flexSchemeLight,
      // ),
      // darkTheme: ThemeData(
      //   useMaterial3: true,
      //   colorScheme: flexSchemeDark,
      // ),

      // ThemeMode toggle via callback
      home: HomePage(
        themeMode: themeMode,
        onThemeModeChanged: (ThemeMode mode) {
          setState(() {
            themeMode = mode;
          });
        },
      ),
    );
  }
}

// Copy-paste the code for a ColorScheme you want from the
// Themes Playground here and try it with plain vanilla
// ThemeData(colorScheme: flexSchemeLight/flexSchemeDark) by
// uncommenting that section above.
//
// Light and dark ColorSchemes made by FlexColorScheme v7.1.1.
// These ColorScheme objects require Flutter 3.7 or later.
const ColorScheme flexSchemeLight = ColorScheme(
  brightness: Brightness.light,
  primary: Color(0xff00497f),
  onPrimary: Color(0xfffdfcff),
  primaryContainer: Color(0xffd2e4ff),
  onPrimaryContainer: Color(0xff001c37),
  secondary: Color(0xff287eab),
  onSecondary: Color(0xfffbfcff),
  secondaryContainer: Color(0xffe4f3ff),
  onSecondaryContainer: Color(0xff001e2e),
  tertiary: Color(0xffdd520f),
  onTertiary: Color(0xffffffff),
  tertiaryContainer: Color(0xffffdbcf),
  onTertiaryContainer: Color(0xff380d00),
  error: Color(0xffba1a1a),
  onError: Color(0xfffffbff),
  errorContainer: Color(0xffffdad6),
  onErrorContainer: Color(0xff410002),
  background: Color(0xfff6f7fb),
  onBackground: Color(0xff191c20),
  surface: Color(0xfff6f7fb),
  onSurface: Color(0xff191c20),
  surfaceVariant: Color(0xffd6deea),
  onSurfaceVariant: Color(0xff414750),
  outline: Color(0xff717782),
  outlineVariant: Color(0xffc1c7d2),
  shadow: Color(0xff000000),
  scrim: Color(0xff000000),
  inverseSurface: Color(0xff2c3137),
  onInverseSurface: Color(0xffeff0f7),
  inversePrimary: Color(0xffa0c9ff),
  surfaceTint: Color(0xff00497f),
);

// Normally the dark mode ColorScheme would be the matching pair to the
// light one, but it does not have to be. Same applies when you use
// FlexColorScheme to make your ThemeData.
const ColorScheme flexSchemeDark = ColorScheme(
  brightness: Brightness.dark,
  primary: Color(0xffa0c9ff),
  onPrimary: Color(0xff001c37),
  primaryContainer: Color(0xff00497f),
  onPrimaryContainer: Color(0xffd2e4ff),
  secondary: Color(0xffc7e7ff),
  onSecondary: Color(0xff001e2e),
  secondaryContainer: Color(0xff00344c),
  onSecondaryContainer: Color(0xffc7e7ff),
  tertiary: Color(0xffffb59a),
  onTertiary: Color(0xff380d00),
  tertiaryContainer: Color(0xff753318),
  onTertiaryContainer: Color(0xffffdbcf),
  error: Color(0xffffb4ab),
  onError: Color(0xff410002),
  errorContainer: Color(0xff93000a),
  onErrorContainer: Color(0xffffb4ab),
  background: Color(0xff13161a),
  onBackground: Color(0xffe1e2e8),
  surface: Color(0xff13161a),
  onSurface: Color(0xffe1e2e8),
  surfaceVariant: Color(0xff3a4049),
  onSurfaceVariant: Color(0xffc1c7d2),
  outline: Color(0xff8b919c),
  outlineVariant: Color(0xff414750),
  shadow: Color(0xff000000),
  scrim: Color(0xff000000),
  inverseSurface: Color(0xffedeef2),
  onInverseSurface: Color(0xff2e3135),
  inversePrimary: Color(0xff0061a6),
  surfaceTint: Color(0xffa0c9ff),
);
