plugins {
    id("com.android.library")
    id("org.jetbrains.kotlin.android")
    alias(libs.plugins.gradlePlugin.compose.compiler)
}

android {
    namespace = "proton.android.pass.navigation.api"
    compileSdk = libs.versions.compileSdk.get().toInt()

    defaultConfig {
        minSdk = libs.versions.minSdk.get().toInt()
        
    }

    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_17
        targetCompatibility = JavaVersion.VERSION_17
    }

    kotlinOptions {
        jvmTarget = JavaVersion.VERSION_17.toString()
    }

    buildFeatures {
        compose = true
    }
}

androidComponents.beforeVariants { variant ->
    variant.enableAndroidTest = false
}

dependencies {
    implementation(libs.kotlin.reflect)
    implementation(libs.kotlinx.coroutines.core)
    implementation(libs.accompanist.navigation.material)

    implementation(platform(libs.androidx.compose.bom))
    implementation(libs.bundles.core.compose)

    implementation(libs.core.cryptoAndroid)
    implementation(libs.core.cryptoCommon)
    implementation(libs.core.utilKotlin)
    implementation(libs.androidx.navigation.compose)

    api(libs.androidx.compose.runtime)

    implementation(projects.pass.common.api)
    implementation(projects.pass.crypto.api)
    implementation(projects.pass.log.api)

    testImplementation(libs.core.test.kotlin)
    testImplementation(libs.junit)
    testImplementation(libs.kotlinTest)
    testImplementation(libs.truth)
}
