/*
 * Copyright (c) 2024 Proton AG
 * This file is part of Proton AG and Proton Pass.
 *
 * Proton Pass is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Proton Pass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Proton Pass.  If not, see <https://www.gnu.org/licenses/>.
 */

package proton.android.pass.features.security.center.shared.ui.image

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.size
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import proton.android.pass.features.security.center.R

@Composable
internal fun BreachImage(modifier: Modifier = Modifier, isResolved: Boolean) {
    val breachImageResId = if (isResolved) {
        R.drawable.shield_bolt_neutral_big_grey
    } else {
        R.drawable.shield_bolt_neutral_big_red
    }

    Image(
        painter = painterResource(id = breachImageResId),
        contentDescription = null,
        modifier = modifier.size(40.dp),
        alignment = Alignment.CenterStart
    )
}
