/*
 * Copyright (c) 2025 Proton AG
 * This file is part of Proton AG and Proton Pass.
 *
 * Proton Pass is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Proton Pass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Proton Pass.  If not, see <https://www.gnu.org/licenses/>.
 */

package proton.android.pass.data.impl.crypto

import proton.android.pass.common.api.safeRunCatching
import proton.android.pass.log.api.PassLogger

internal suspend fun <T> fetchWithForceRefresh(
    tag: String,
    initial: suspend () -> T?,
    refresh: suspend () -> T?
): T? = safeRunCatching {
    initial()?.let { return it }
    PassLogger.d(tag, "Initial fetch returned null. Retrying with force refresh.")
    refresh()
}.onFailure {
    PassLogger.w(tag, "Initial fetch failed. Retrying with force refresh.")
    PassLogger.w(tag, it)
    safeRunCatching { refresh() }
        .onFailure { t ->
            PassLogger.w(tag, "Force-refresh fetch also failed.")
            PassLogger.w(tag, it)
        }
        .getOrElse { t -> null }
}.getOrElse { t -> null }

