/*
 * Copyright (c) 2023 Proton AG
 * This file is part of Proton AG and Proton Pass.
 *
 * Proton Pass is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Proton Pass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Proton Pass.  If not, see <https://www.gnu.org/licenses/>.
 */

package proton.android.pass.composecomponents.impl.keyboard

import androidx.compose.foundation.layout.WindowInsets
import androidx.compose.foundation.layout.ime
import androidx.compose.runtime.Composable
import androidx.compose.runtime.State
import androidx.compose.runtime.rememberUpdatedState
import androidx.compose.ui.platform.LocalDensity

enum class IsKeyboardVisible {
    VISIBLE,
    GONE;

    companion object {
        fun from(isVisible: Boolean): IsKeyboardVisible = if (isVisible) VISIBLE else GONE
    }
}

@Composable
fun keyboardAsState(): State<IsKeyboardVisible> {
    val isImeVisible = WindowInsets.ime.getBottom(LocalDensity.current) > 0
    val isKeyboardVisible = IsKeyboardVisible.from(isImeVisible)
    return rememberUpdatedState(isKeyboardVisible)
}
