/*
 * Copyright (c) 2023 Proton AG
 * This file is part of Proton AG and Proton Pass.
 *
 * Proton Pass is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Proton Pass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Proton Pass.  If not, see <https://www.gnu.org/licenses/>.
 */

package proton.android.pass.commonui.api

import androidx.compose.ui.graphics.Brush
import androidx.compose.ui.graphics.Color

object PassPalette {
    val Lavender100 = Color(0xFFA779FF)
    val Lavender8 = Color(0x14A779FF)
    val GreenSheen100 = Color(0xFF6ABDB3)
    val GreenSheen8 = Color(0x146ABDB3)
    val MacaroniAndCheese100 = Color(0xFFFFCA8A)
    val MacaroniAndCheese16 = Color(0x29FFCA8A)
    val MacaroniAndCheese8 = Color(0x14FFCA8A)
    val White100 = Color(0xFFFFFFFF)
    val White90 = Color(0xE6FFFFFF)
    val White10 = Color(0x1AFFFFFF)
    val EerieBlack = Color(0xFF191927)
    val DarkGunmetal = Color(0xFF1F1F31)
    val SmokyBlack = Color(0xFF0E0E0E)

    val VanillaIce = Color(0xFFF08FA4)
    val PastelOrange = Color(0xFFFFB84D)
    val OceanGreen = Color(0xFF4AB89A)
    val PictonBlue = Color(0xFF4AC0FF)

    val Indigo = Color(0xFF6D4AFF)
    val LavenderMist = Color(0xFFE6E0FE)

    val LavenderFloral = Color(0xFFBA80E6)
    val LavenderPink = Color(0xFFECDFFA)
    val LilacMist = Color(0xFFF6F0FD)

    val ShamrockGreen = Color(0xFF10B981)
    val AzureishWhite = Color(0xFFD9F4EB)
    val Honeydew = Color(0xFFECFAF5)

    val Bronze = Color(0xFFD9772F)
    val VeryLightTangelo = Color(0xFFFFAF77)
    val Flesh = Color(0xFFFFE5D3)
    val OldLace = Color(0xFFFFF2E9)

    val Tulip = Color(0xFFFF8387)
    val LightSalmonPink = Color(0xFFFC9C9F)
    val Pink = Color(0xFFC4FDFC)
    val Linen = Color(0xFFFEEBEC)

    val DarkCharcoal = Color(0xFF333333)
    val GraniteGray = Color(0xFF666666)
    val SilverChalice = Color(0xFFADADAD)
    val BrightGray = Color(0xFFEBEBEB)

    val DingyDungeon = Color(0xFFCC2D4F)
    val Persimmon = Color(0xFFE65200)
    val SpanishViridian = Color(0xFF007B58)
    val Cyan = Color(0xFF00AFE6)
    val RichBlack = Color(0xFF0C0C14)

    val AliceBlue = Color(0xFFEFF3FB)
    val Whisper = Color(0xFFF6F5F8)

    val Black32 = Color(0x52000000)

    val Heliotrope = Color(0xFFA779FF)
    val Mauvelous = Color(0xFFF29292)
    val Begonia = Color(0xFFFF7474)
    val MarigoldYellow = Color(0xFFF7D775)
    val AmericanYellow = Color(0xFFEAB000)
    val DeYork = Color(0xFF91C799)
    val JungleGreen = Color(0xFF20AE95)
    val JordyBlue = Color(0xFF92B3F2)
    val CornflowerBlue = Color(0xFF64A2FF)
    val LavenderMagenta = Color(0xFFEB8DD6)
    val RosePink = Color(0xFFFB68DB)
    val ChestnutRose = Color(0xFFCD5A6F)
    val BrickRed = Color(0xFFCE3A55)
    val Porsche = Color(0xFFE4A367)
    val DeepSaffron = Color(0xFFFF8F28)
    val Mercury = Color(0xFFE6E6E6)
    val SpanishGray = Color(0xFF959494)
    val WaterLeaf = Color(0xFF9EE2E6)
    val MaximumBlueGreen = Color(0xFF31C8D1)

    val HeliotropeLight = Color(0xFF8849FF)
    val MauvelousLight = Color(0xFFFF4949)
    val MarigoldYellowLight = Color(0xFFCC6200)
    val DeYorkLight = Color(0xFF006677)
    val JordyBlueLight = Color(0xFF3B88FC)
    val LavenderMagentaLight = Color(0xFFDD11B0)
    val ChestnutRoseLight = Color(0xFFCB0126)
    val PorscheLight = Color(0xFFFF7A00)
    val MercuryLight = Color(0xFF757575)
    val WaterLeafLight = Color(0xFF149AA1)

    val Cornflower = Color(0xFF7777F8)
    val YankeesBlue = Color(0xFF202038)
    val EbonyClay = Color(0xFF282848)
    val SlateBlue = Color(0xFF6464CE)
    val DeepBirch = Color(0xFF242138)
    val MysticNight = Color(0xFF30284A)
    val LavenderHaze = Color(0xFF8B66D4)
    val OrchidHue = Color(0xFFA779FF)
    val RoyalPurple = Color(0xFF7328C5)
    val AmethystHaze = Color(0xFFB994FF)
    val MidnightMood = Color(0xFF1F2632)
    val MoonlitWave = Color(0xFF26333D)
    val MistyPool = Color(0xFF5A9C97)
    val OceanFoam = Color(0xFF6ABDB3)
    val ShadowInk = Color(0xFF2B272F)
    val MauveWine = Color(0xFF3E3537)
    val DustyTrail = Color(0xFFD1A776)
    val PeachCream = Color(0xFFFFCA8A)
    val PlumPassion = Color(0xFF2B2331)
    val BerryWine = Color(0xFF3D2E3A)
    val BlossomPink = Color(0xFFCF8287)
    val CoralCandy = Color(0xFFFC9C9F)
    val MistyGray = Color(0xFFD1D1D4)
    val StoneHarbor = Color(0xFF8C8C93)
    val NightSlate = Color(0xFF50505B)
    val MidnightSlate = Color(0xFF2B2B38)
    val ShadowyCove = Color(0xFF13131D)
    val MysticNightFall = Color(0xFF282839)
    val DarkSlateGray = Color(0xFF363648)
    val StormyNight100 = Color(0xFF222230)
    val StormyNight70 = Color(0xB2222230)
    val NightHorizon = Color(0xFF343441)
    val WinterBreeze = Color(0xFFEEEDF0)
    val MistyMorning = Color(0xFFE2E1E4)
    val BrightWhite = Color(0xFFF5F5F5)
    val BlueIris = Color(0xFF9292F9)
    val TealPine = Color(0xFF136C4F)
    val CinnamonSwirl = Color(0xFFA14300)
    val ElectricIndigo = Color(0xFF6243E6)
    val OrchidPink = Color(0xFFBA80E6)
    val LavenderBloom = Color(0xFFA792FF)
    val BabyBlueEyes = Color(0xFFF2EFFF)
    val PearlWhite = Color(0xFFEAE7E4)
    val CrimsonRed = Color(0xFF7E1013)
    val BubbleGum = Color(0xFFFDB0B2)
    val CottonCandy = Color(0xFFFFD9D9)

    val MidnightBlue = Color(0xFF273035)
    val DeepJungleGreen = Color(0xFF364843)
    val MintLeaf = Color(0xFF79B585)
    val LightPastelGreen = Color(0xFF91DC9C)
    val PaleGreen = Color(0xFFABE4B4)

    val FrostedMint = Color(0xFFEAF5E1)
    val PaleLime = Color(0xFFDCF2CA)
    val ForestGreen = Color(0xFF51940D)
    val LimeGreen = Color(0xFF66C146)
    val DarkGreen = Color(0xFF317806)

    val ValleyNight = Color(0xFF302D45)
    val IvoryWhite = Color(0xFFEDEDED)

    val SilverFog = Color(0xBBEEEEEE)
    val CharcoalSmoke = Color(0xBB333333)

    val VividViolet = Color(0xFF9251EB)
    val IndigoViolet = Color(0xFF5B53ED)
    val PaleApricot = Color(0x1AFFD580)

    val SlateGray = Color(0x4D88859D)
    val MistGray = Color(0x4DB8B6C4)

    val PromoYellow = Color(0xFFDBFF00)

    val gradientBrushDark = Brush.linearGradient(
        colorStops = arrayOf(
            0f to BlossomPink,
            GRADIENT_STEP_1 to Color(color = 0xFF4B3379),
            GRADIENT_STEP_2 to DarkGunmetal
        )
    )

    val gradientBrushLight = Brush.linearGradient(
        colorStops = arrayOf(
            0f to BlossomPink,
            GRADIENT_STEP_1 to Color(color = 0xFFEFD2D8),
            GRADIENT_STEP_2 to Color(color = 0xFFFBF9FE)
        )
    )

    val welcomeGradientDark = Brush.verticalGradient(
        colorStops = arrayOf(
            0f to Color(color = 0xFF3B1A64),
            0.4107f to Color(color = 0xFF2F1354),
            0.9875f to Color(color = 0xFF250D47)
        )
    )

    val welcomeGradientLight = Brush.verticalGradient(
        colorStops = arrayOf(
            0f to Color(color = 0xFFD292FF),
            0.246f to Color(color = 0xFFE6D2EF),
            0.5671f to Color(color = 0xFFFBF9FE)
        )
    )

    val upsellLightBackgroundColor = Color(color = 0xFFF4F0FE)
}

private const val GRADIENT_STEP_1 = 0.2595f
private const val GRADIENT_STEP_2 = 0.4416f
