/*
 * Copyright (c) 2023 Proton AG
 * This file is part of Proton AG and Proton Pass.
 *
 * Proton Pass is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Proton Pass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Proton Pass.  If not, see <https://www.gnu.org/licenses/>.
 */

package proton.android.pass.commonrust.impl

import proton.android.pass.commonrust.AliasPrefixException
import proton.android.pass.commonrust.api.AliasPrefixError
import proton.android.pass.commonrust.api.AliasPrefixValidator
import javax.inject.Inject
import javax.inject.Singleton
import proton.android.pass.commonrust.AliasPrefixValidator as RustValidator

@Singleton
class AliasPrefixValidatorImpl @Inject constructor() : AliasPrefixValidator {

    private val aliasPrefixValidator by lazy { RustValidator() }

    override fun validate(prefix: String) = runCatching {
        aliasPrefixValidator.validate(prefix)
    }.fold(
        onSuccess = { Result.success(Unit) },
        onFailure = {
            when (it) {
                is AliasPrefixException.DotAtTheBeginning -> Result.failure(AliasPrefixError.DotAtTheBeginning)
                is AliasPrefixException.DotAtTheEnd -> Result.failure(AliasPrefixError.DotAtTheEnd)
                is AliasPrefixException.InvalidCharacter -> Result.failure(AliasPrefixError.InvalidCharacter)
                is AliasPrefixException.PrefixEmpty -> Result.failure(AliasPrefixError.PrefixEmpty)
                is AliasPrefixException.PrefixTooLong -> Result.failure(AliasPrefixError.PrefixTooLong)
                is AliasPrefixException.TwoConsecutiveDots -> Result.failure(AliasPrefixError.TwoConsecutiveDots)
                else -> Result.failure(it)
            }
        }
    )
}
