/*
 * Copyright (c) 2025 Proton AG
 * This file is part of Proton AG and Proton Authenticator.
 *
 * Proton Authenticator is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Proton Authenticator is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Proton Authenticator.  If not, see <https://www.gnu.org/licenses/>.
 */

package proton.android.authenticator.shared.ui.domain.components.rows

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Switch
import androidx.compose.material3.SwitchDefaults
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import proton.android.authenticator.shared.ui.domain.models.UiText
import proton.android.authenticator.shared.ui.domain.theme.Theme
import proton.android.authenticator.shared.ui.domain.theme.ThemePadding
import proton.android.authenticator.shared.ui.domain.theme.ThemeSpacing

@Composable
fun ToggleRow(
    titleText: UiText,
    isChecked: Boolean,
    onCheckedChange: (Boolean) -> Unit,
    descriptionText: UiText? = null
) {
    Row(
        modifier = Modifier
            .fillMaxWidth()
            .clickable { onCheckedChange(!isChecked) }
            .padding(
                horizontal = ThemePadding.Medium,
                vertical = ThemePadding.MediumSmall
            ),
        horizontalArrangement = Arrangement.spacedBy(space = ThemeSpacing.Medium),
        verticalAlignment = Alignment.CenterVertically
    ) {
        Column(
            modifier = Modifier.weight(weight = 1f, fill = true),
            verticalArrangement = Arrangement.spacedBy(space = ThemeSpacing.ExtraSmall)
        ) {
            Text(
                text = titleText.asString(),
                color = Theme.colorScheme.textNorm,
                style = Theme.typography.body1Regular
            )

            descriptionText?.let { text ->
                Text(
                    text = text.asString(),
                    color = Theme.colorScheme.textWeak,
                    style = Theme.typography.body2Regular
                )
            }
        }

        Switch(
            checked = isChecked,
            onCheckedChange = null,
            colors = SwitchDefaults.colors()
                .copy(
                    checkedBorderColor = Theme.colorScheme.signalSuccess,
                    checkedThumbColor = Theme.colorScheme.white,
                    checkedTrackColor = Theme.colorScheme.signalSuccess,
                    uncheckedBorderColor = Theme.colorScheme.transparent,
                    uncheckedThumbColor = Theme.colorScheme.textNorm,
                    uncheckedTrackColor = Theme.colorScheme.textPlaceholder
                )
        )
    }
}
