/*
 * Copyright (c) 2024 Proton AG
 * This file is part of Proton AG and Proton Pass.
 *
 * Proton Pass is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Proton Pass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Proton Pass.  If not, see <https://www.gnu.org/licenses/>.
 */

package proton.android.authenticator.di

import dagger.Binds
import dagger.Module
import dagger.hilt.InstallIn
import dagger.hilt.components.SingletonComponent
import me.proton.core.domain.entity.UserId
import me.proton.core.telemetry.domain.usecase.IsTelemetryEnabled
import proton.android.authenticator.app.telemetry.CanConfigureTelemetry
import javax.inject.Inject

class IsTelemetryEnabledFdroidImpl @Inject constructor(): IsTelemetryEnabled {
    override suspend fun invoke(userId: UserId?): Boolean = false
}

class CanConfigureTelemetryFdroidImpl @Inject constructor(): CanConfigureTelemetry {
    override fun invoke() = false
}

@Module
@InstallIn(SingletonComponent::class)
public interface AccountEnableTelemetryModule {

    @Binds
    public fun bindCanConfigureTelemetry(impl: CanConfigureTelemetryFdroidImpl): CanConfigureTelemetry

    @Binds
    public fun bindIsTelemetryEnabled(impl: IsTelemetryEnabledFdroidImpl): IsTelemetryEnabled
}
