/*
 * Copyright (c) 2025 Proton AG
 * This file is part of Proton AG and Proton Authenticator.
 *
 * Proton Authenticator is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Proton Authenticator is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Proton Authenticator.  If not, see <https://www.gnu.org/licenses/>.
 */

package proton.android.authenticator.features.backups.passwords.presentation

import androidx.compose.runtime.Stable

@Stable
internal data class BackupsPasswordState(
    internal val password: String,
    internal val checkPassword: String,
    internal val isPasswordVisible: Boolean,
    internal val isCheckPasswordVisible: Boolean,
    internal val event: BackupsPasswordEvent
) {

    internal val isConfirmEnabled: Boolean =
        password.isNotBlank() && checkPassword.isNotBlank() && password == checkPassword

    internal companion object {

        internal val Initial: BackupsPasswordState = BackupsPasswordState(
            password = "",
            checkPassword = "",
            isPasswordVisible = false,
            isCheckPasswordVisible = false,
            event = BackupsPasswordEvent.Idle
        )

    }

}
