/*
 * Copyright (c) 2025 Proton AG
 * This file is part of Proton AG and Proton Authenticator.
 *
 * Proton Authenticator is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Proton Authenticator is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Proton Authenticator.  If not, see <https://www.gnu.org/licenses/>.
 */

package proton.android.authenticator.business.entries.domain

import proton.android.authenticator.commonrust.AuthenticatorEntryModel
import proton.android.authenticator.commonrust.RemoteEntry

internal data class EntryRemote(
    internal val id: String,
    internal val revision: Int,
    internal val position: Int,
    internal val createdAt: Long,
    internal val modifiedAt: Long,
    internal val model: AuthenticatorEntryModel
) {

    internal val localId: String = model.id

    internal val operation: RemoteEntry = RemoteEntry(
        remoteId = id,
        revision = revision.toUInt(),
        modifyTime = modifiedAt,
        entry = model
    )

}
