<p align="center"><img src="https://cdn.oblivioncoding.pro/fluffy_board/AppLogo.png" height="200" alt="Logo"></p>

<h1 align="center">Fluffyboard</h1>

<p align="center">Fluffyboard is a open source, free and self-hostable Whiteboard Application</p>
<p align="center">Test the <a href="https://fluffyboard.obco.pro/">demonstration</a> of Fluffyboard</p>

<p align="center">
  <a href='https://play.google.com/store/apps/details?id=pro.oblivioncoding.fluffy_board'>
    <img alt='Get it on Google Play' src='https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png'/ height="100">
  </a>
  <a href='https://f-droid.org/packages/pro.oblivioncoding.fluffy_board/'>
    <img alt='Get it on F-Droid' src='https://fdroid.gitlab.io/artwork/badge/get-it-on.png'/ height="100">
  </a>
</p>
<p align="center">
  <img src="https://img.shields.io/docker/cloud/automated/yonggan/fluffy_board-web" alt="Docker Cloud Automated build" heigt="50">
  <img src="https://img.shields.io/docker/cloud/build/yonggan/fluffy_board-web" alt="Docker Cloud Build Status" heigt="50">
  <img alt="GitHub tag (latest SemVer)" src="https://img.shields.io/github/v/tag/Y0ngg4n/fluffy_board" heigt="50">
  <img alt="GitHub language count" src="https://img.shields.io/github/languages/count/Y0ngg4n/fluffy_board" heigt="50">
  <img alt="GitHub" src="https://img.shields.io/github/license/Y0ngg4n/fluffy_board" heigt="50">
  <a href="https://github.com/Y0ngg4n/fluffy_board/actions/workflows/dockerhub.yaml"><img alt="Push to Dockerhub" src="https://github.com/Y0ngg4n/fluffy_board/actions/workflows/dockerhub.yaml/badge.svg"/></a>
</p>

<h2>Table of Contents</h2>

<ol>
    <li><a href="#Features">Features</a></li>
    <li><a href="#Installation">Installation</a></li>
    <li><a href="#Roadmap">Roadmap</a></li>
    <li><a href="#Contributing">Contributing</a></li>
    <li><a href="#License">License</a></li>
</ol>

<h2 id="Features">Features</h2>

<ul>
    <li><i>Online</i> Whiteboards</li>
    <li><i>Offline</i> Whiteboards</li>
    <li>Downloading and Uploading Whiteboards</li>
    <li>Import and Export Whiteboards</li>
    <li>Organizing Whiteboards in Folders</li>
    <li>Sharing online Whiteboards with readonly and write Permissions</li>
    <li>Drawing lines</li>
    <li>Highlighting</li>
    <li>Drawing Straight Lines and Arrows</li>
    <li>Drawing Rects, Triangles and Circles</li>
    <li>Adding Text</li>
    <li>Uploading Images</li>
    <li>Importing PDF</li>
    <li>Changing Background</li>
    <li>Settings sync</li>
    <li>Adding bookmarks</li>
    <li>Changing Toolbar location</li>
</ul>



<h2 id="Installation">Installation</h2>

### Web instance

For the <a href="https://hub.docker.com/repository/docker/yonggan/fluffy_board-web/">Docker image</a> see more on DockerHub.

To set up your own web instance visit the <a href="Repository">Fluffy REST API Repository</a>.

### Windows

Download the `Fluffyboard-windows.zip` from the <a href="https://github.com/Y0ngg4n/fluffy_board/releases">latest Release</a>.

Extract the zip archive and place it's contents in the folder of your choice.

### Linux

Download the `Fluffyboard-linux.zip` from the <a href="https://github.com/Y0ngg4n/fluffy_board/releases">latest Release</a>.

Extract the zip archive and and place it's contents in the folder of your choice.

Give the executable the required permissions.

```terminal
chmod +x fluffy_board
```

Create a *symbolic link* to the executable in `/usr/local/bin/`.

```sh
sudo ln -s /home/USERNAME/PATH/TO/EXECUTABLE /usr/local/bin/fluffyboard
```

### macOS

Download the `Fluffyboard-mac.zip` from the <a href="https://github.com/Y0ngg4n/fluffy_board/releases">latest Release</a>.

Extract the zip archive and and place it's contents in the folder of your choice.

Give the executable the required permissions.

```sh
chmod +x fluffy_board.app
```

You can now find ***Fluffyboard*** in `Finder`.

<h2 id="Roadmap">Roadmap</h2>

You can find the <a href="https://github.com/Y0ngg4n/fluffy_board/projects/2">current roadmap</a> in `Projects`.

<h2 id="Contributing">Contributing</h2>

Contributions are always welcome!

<h2 id="License">License</h2>

***Fluffyboard*** is licensed under the <a href="GNU General Public License v3.0">GNU General Public License v3.0</a>.

