extends Node

var drops = 3 # highest level for starter drop
var next_drop = 1
var points = 0
var highscores = {}
var achievements = {}
var all_achievements = {"0":false,"1":false, "2": false}#,"2":false,"3":false} 
var all_achievements_description = {"0":"5000 POINTS","1":"WATERMELON GAME","2":"POWER POWER"}#,"2":"insert description","3":"insert description"}
var unlocked_index

var settings = {"GENERIC": {"sound": true, "music": true, "effects": true}, "RECIPE": {"gamemode": "classic", "theme": "classic", "background": "scroll"}}

var active_powerup = "NONE"
var powerup1_available = "NONE"
var powerup2_available = "NONE"
var new_powerup_chance = 10
var used_powerups = 0 # for this game session

var pu_seeds_texture = preload("res://assets/sprites/classic/objects/powerup_seed.png")
var pu_ice_texture = preload("res://assets/sprites/classic/objects/powerup_ice.png")

# global settings for sandbox
var default = {"gravity_scale": 1}
var gravity_scale = 2

func _ready():
	get_tree().quit_on_go_back = false # should work, for disabling quitting app on back button # we can put this in another script if it breaks something here
	var file = File.new()
	if file.file_exists("user://scores.json"): #reads scores
		file.open("user://scores.json", file.READ)
		highscores = parse_json(file.get_as_text())
		
	var file2 = File.new()
	if file2.file_exists("user://achiev.json"): #reads achiev
		file2.open("user://achiev.json", file2.READ)
		achievements = parse_json(file2.get_as_text())
		
		if(achievements.size()!=all_achievements.size()):#if new achievements are added with an update
			add_new_achievements() 			
	else:	
		achievements = all_achievements #if there isnt already a file all achiev are false
		
	var file3 = File.new()
	if file3.file_exists("user://config.json"):
		file3.open("user://config.json", file.READ)
		settings = parse_json(file3.get_as_text())
	
	if settings["RECIPE"].has("gamemode"):
		$UI2/Menu/Recipe/Control/classic/cb_Classic.pressed = false
		$UI2/Menu/Recipe/Control/arcade/cb_Arcade.pressed = false
		if settings["RECIPE"]["gamemode"] == "classic":
			$UI2/Menu/Recipe/Control/classic/cb_Classic.pressed = true
		elif settings["RECIPE"]["gamemode"] == "arcade":
			$UI2/Menu/Recipe/Control/arcade/cb_Arcade.pressed = true
	
	if settings["RECIPE"].has("theme"):
		$UI2/Menu/Recipe2/Control/theme_classic/cb_ClassicTheme.pressed = false
		$UI2/Menu/Recipe2/Control/theme_material/cb_MaterialTheme.pressed = false
		$UI2/Menu/Recipe2/Control/theme_watercolor/cb_WaterColorTheme.pressed = false
		if settings["RECIPE"]["theme"] == "classic":
			$UI2/Menu/Recipe2/Control/theme_classic/cb_ClassicTheme.pressed = true
		elif settings["RECIPE"]["theme"] == "material":
			$UI2/Menu/Recipe2/Control/theme_material/cb_MaterialTheme.pressed = true
		elif settings["RECIPE"]["theme"] == "watercolor":
			$UI2/Menu/Recipe2/Control/theme_watercolor/cb_WaterColorTheme.pressed = true
	else:
		settings["RECIPE"]["theme"] = "classic"
	if settings["RECIPE"].has("background"):
		$UI2/Menu/Recipe2/Control/background_white/cb_BackgroundWhite.pressed = false
		$UI2/Menu/Recipe2/Control/background_scroll/cb_BackgroundScroll.pressed = false
		if settings["RECIPE"]["background"] == "white":
			$UI2/Menu/Recipe2/Control/background_white/cb_BackgroundWhite.pressed = true
		elif settings["RECIPE"]["background"] == "scroll":
			$UI2/Menu/Recipe2/Control/background_scroll/cb_BackgroundScroll.pressed = true
	else:
		settings["RECIPE"]["background"] = "scroll"
	if settings.has("GENERIC"):
		if settings["GENERIC"]["sound"]:
			#AudioServer.set_bus_volume_db(AudioServer.get_bus_index("Master"), 1) # just pass this
			AudioServer.set_bus_mute(0,false)
		else:
			AudioServer.set_bus_mute(0,true)
		if settings["GENERIC"]["effects"]:
			AudioServer.set_bus_mute(1,false)
		else:
			AudioServer.set_bus_mute(1,true)
		if settings["GENERIC"]["music"]:
			AudioServer.set_bus_mute(2,false)
		else:
			AudioServer.set_bus_mute(2,true)
		$UI2/Menu/Recipe/Control/sound/cb_Sound.pressed = settings["GENERIC"]["sound"]
		$UI2/Menu/Recipe/Control/effects/cb_Effects.pressed = settings["GENERIC"]["effects"] # for audio not visuals
		#$UI2/Menu/Recipe/Control/music/cb_Music.pressed = settings["GENERIC"]["music"]
	else:
		settings["GENERIC"] = {"sound": true, "music": true, "effects": true}
		AudioServer.set_bus_mute(0,false)
	
	var config_file = File.new()
	config_file.open("user://config.json", File.WRITE)
	config_file.store_line(to_json(settings))

func _process(delta):
	$UI/Control/Score.text = str(points)
	$UI/Control/Timer.text = str(round($UI/Control/Timer/TimerModeTimer.time_left))
	if !achievements['0']:
		if points > 5000:
			unlocked_index='0'
			unlocked_achievement()

func dropped():
	var ran = RandomNumberGenerator.new()
	ran.randomize()
	var test_drop = ran.randi_range(1, drops)
	if test_drop == next_drop and ran.randi_range(1, 15) > 10:
		dropped()
	else:
		next_drop = test_drop
		$UI/Control/NextDrop.texture = load("res://assets/sprites/"+settings["RECIPE"]["theme"]+"/objects/level"+str(next_drop)+".png")
	if ran.randf()*100 < new_powerup_chance:
		if powerup1_available == "NONE":
			new_powerup_chance = 0
			$UI/Control2/Up1.visible = true
			if ran.randi_range(1, 2) == 1:
				powerup1_available = "ICE"
				$UI/Control2/Up1.texture_normal = pu_ice_texture
			else:
				powerup1_available = "SEEDS"
				$UI/Control2/Up1.texture_normal = pu_seeds_texture
		elif powerup2_available == "NONE":
			new_powerup_chance = 0
			$UI/Control2/Up2.visible = true
			if ran.randi_range(1, 2) == 1:
				powerup2_available = "ICE"
				$UI/Control2/Up2.texture_normal = pu_ice_texture
			else:
				powerup2_available = "SEEDS"
				$UI/Control2/Up2.texture_normal = pu_seeds_texture

var last_touched

func _on_Line_body_entered(body):
	if $UI/Line.get_overlapping_areas().size() == 1:
		$UI/Line/Timer.start()

func _on_Line_body_exited(body):
	if $UI/Line.get_overlapping_areas().size() == 1:
		$UI/Line/Timer.stop()

func game_end():
	$UI2/GameEnd.visible = true
	save_score()

func save_score():
	if settings["RECIPE"]["gamemode"] == "classic":
		if points > 0 and highscores.values().has(points) == false:
			var score_file = File.new()
			score_file.open("user://scores.json", File.WRITE)
			highscores[highscores.size()+1] = points
			score_file.store_line(to_json(highscores))
	elif settings["RECIPE"]["gamemode"] == "arcade":
		pass

func _on_play_pressed():
	reset_game()
	$UI2/Menu.visible = false
	$UI2/Pause.visible = false
	$UI.visible = true
	$Game.visible = true
	if settings["RECIPE"]["theme"] == "classic": # maybe move this all just to when setting is changed?
		fill_theme(settings["RECIPE"]["theme"])
	elif settings["RECIPE"]["theme"] == "material":
		fill_theme(settings["RECIPE"]["theme"])
	elif settings["RECIPE"]["theme"] == "watercolor":
		fill_theme(settings["RECIPE"]["theme"])
	if settings["RECIPE"]["background"] == "white":
		$UI/Background.texture = load("res://assets/sprites/classic/environment/background.png")
	elif settings["RECIPE"]["background"] == "scroll":
		$UI/Background.texture = load("res://assets/sprites/classic/environment/background2.png")
	if settings["RECIPE"]["gamemode"] == "arcade":
		$UI/label_ArcadeNotice.visible = true
		yield(get_tree().create_timer(0.1), "timeout")
		$UI/label_ArcadeNotice.visible = false
		yield(get_tree().create_timer(0.1), "timeout")
		$UI/label_ArcadeNotice.visible = true
		yield(get_tree().create_timer(0.1), "timeout")
		$UI/label_ArcadeNotice.visible = false
		yield(get_tree().create_timer(0.1), "timeout")
		$UI/label_ArcadeNotice.visible = true
		yield(get_tree().create_timer(0.1), "timeout")
		$UI/label_ArcadeNotice.visible = false
		yield(get_tree().create_timer(0.1), "timeout")
		$UI/label_ArcadeNotice.visible = true
		yield(get_tree().create_timer(0.1), "timeout")
		$UI/label_ArcadeNotice.visible = false
		$UI/Control2.visible = true
	else:
		$UI/label_ArcadeNotice.visible = false
		$UI/Control2.visible = false

func fill_theme(theme):
	pass

func _on_quit_pressed():
	get_tree().quit()

func _notification(what):
	if what == NOTIFICATION_WM_GO_BACK_REQUEST:
		# probably will not disable physics process but I could...
		$UI2.visible = true
		$UI2/Pause.visible = true

func back_to_menu():
	save_score()
	$UI2/Pause.visible = false
	$UI2/GameEnd.visible = false
	$UI2/Menu.visible = true
	$UI.visible = false
	$Game.visible = false
	#reset_game()

func reset_game():
	points = 0
	next_drop = 1
	new_powerup_chance = 10
	powerup1_available = "NONE"
	powerup2_available = "NONE"
	active_powerup = "NONE"
	$UI/Control/NextDrop.texture = load("res://assets/sprites/"+settings["RECIPE"]["theme"]+"/objects/level"+str(next_drop)+".png")
	for child in $Game/Drops.get_children():
		child.queue_free()
	for child in $Game/BackEffects.get_children():
		child.queue_free()

func _input(event):
	if event.is_action_pressed("ui_cancel"):
		# probably will not disable physics process but I could...
		$UI2.visible = true
		$UI2/Pause.visible = true
	if event.is_action_pressed("action_debug"):
		game_end()

func sort_descending(a, b):
	if a > b:
		return true
		
	return false

func _on_btn_Score_pressed():
	if highscores.size() == 0:
		$UI2/Menu/Score/label_NoScore.visible = true
	else:
		for child in $UI2/Menu/Score/sc_Scores/GridContainer.get_children():
			child.queue_free()
		$UI2/Menu/Score/label_NoScore.visible = false
		var score_panel = load("res://scenes/ui/score.tscn")
		var sorted = highscores.values()
		sorted.sort_custom(self, "sort_descending")
		for score in sorted:
			var new_score_panel = score_panel.instance()
			new_score_panel.name = str(score)
			new_score_panel.get_node("label_Score").text =  str(score)
			$UI2/Menu/Score/sc_Scores/GridContainer.add_child(new_score_panel)
			new_score_panel.visible = true
	$UI2/Menu/Score.visible = true

func  _on_btn_Achiev_pressed():
		
	for child in $UI2/Menu/Achiev/sc_Achiev/GridContainer.get_children():
			child.queue_free() 
			
	var achiev_panel = load("res://scenes/ui/achiev.tscn")
	
	for achiev in achievements:
		var new_achiev_panel = achiev_panel.instance()
		new_achiev_panel.name = str(achiev)
		if(achievements[achiev])==true:
			new_achiev_panel.get_node("label_Achiev").text =  str(all_achievements_description[achiev])
		else: new_achiev_panel.get_node("label_Achiev").text = "???"	
		$UI2/Menu/Achiev/sc_Achiev/GridContainer.add_child(new_achiev_panel)
		new_achiev_panel.visible = true
	$UI2/Menu/Achiev.visible = true
	
func unlocked_achievement():	
	if !achievements[unlocked_index]:
		achievements[unlocked_index]=true
		write_achiev()
		$Unlock_notification.visible = true
		yield(get_tree().create_timer(2.0), "timeout")
		$Unlock_notification.visible = false		
		
func add_new_achievements():
	for index in range(achievements.size(),all_achievements.size()):
		achievements[str(index)]=all_achievements[str(index)]
	write_achiev()	 	
		
func write_achiev():			
	var achiev_file = File.new()
	achiev_file.open("user://achiev.json", File.WRITE)
	achiev_file.store_line(to_json(achievements))
	
func _on_btn_Recipe_pressed():
	$UI2/Menu/Recipe.visible = true

func _on_btn_Back_pressed():
	$UI2/Menu/Score.visible = false
	$UI2/Menu/Recipe.visible = false
	$UI2/Menu/Achiev.visible = false
	

func _on_Timer_timeout():
	game_end()

func _on_btn_New_pressed():
	$UI2/GameEnd.visible = false
	$UI2/Menu.visible = false
	$UI.visible = true
	$Game.visible = true
	reset_game()

func _on_btn_Menu_pressed():
	back_to_menu()

func _on_btn_Resume_pressed():
	$UI2/Pause.visible = false

func _on_cb_Classic_pressed():
	settings["RECIPE"]["gamemode"] = "classic"
	var config_file = File.new()
	config_file.open("user://config.json", File.WRITE)
	config_file.store_line(to_json(settings))
	$UI2/Menu/Recipe/Control/classic/cb_Classic.pressed = true
	$UI2/Menu/Recipe/Control/arcade/cb_Arcade.pressed = false
	$UI2/Menu/Recipe/Control/sandbox/cb_Sandbox.pressed = false

func _on_cb_Arcade_pressed():
	settings["RECIPE"]["gamemode"] = "arcade"
	var config_file = File.new()
	config_file.open("user://config.json", File.WRITE)
	config_file.store_line(to_json(settings))
	$UI2/Menu/Recipe/Control/classic/cb_Classic.pressed = false
	$UI2/Menu/Recipe/Control/arcade/cb_Arcade.pressed = true
	$UI2/Menu/Recipe/Control/sandbox/cb_Sandbox.pressed = false

func _on_Up1_pressed():
	$UI/Control2/Up1.visible = false
	active_powerup = powerup1_available
	powerup1_available = "NONE"
	powerup_costume()
	
	used_powerups+=1
	if used_powerups >= 16:
		unlocked_index = "2"
		unlocked_achievement()

func _on_Up2_pressed():
	$UI/Control2/Up2.visible = false
	active_powerup = powerup2_available
	powerup2_available = "NONE"
	powerup_costume()
	
	used_powerups+=1
	if used_powerups >= 16:
		unlocked_index = "2"
		unlocked_achievement()

func powerup_costume():
	if active_powerup == "SEEDS":
		$UI/Dropper/Hold.visible = true
		$UI/Dropper/Hold.texture = preload("res://assets/sprites/classic/objects/seed.png")
	elif active_powerup == "ICE":
		$UI/Dropper/Guy.texture = preload("res://assets/sprites/classic/objects/guy_cold.png")

func _on_btn_Extra_pressed():
	$UI2/Menu/Recipe.visible = false
	$UI2/Menu/Recipe2.visible = true

func _on_btn_ExtraBack_pressed():
	$UI2/Menu/Recipe.visible = true
	$UI2/Menu/Recipe2.visible = false

func _on_sb_Aspect_item_selected(index):
	# :(
	if index == 0:
		print(ProjectSettings.get_setting("display/window/stretch/aspect"))
		ProjectSettings.set_setting("display/window/stretch/aspect", "keep")
		print(ProjectSettings.get_setting("display/window/stretch/aspect"))
	elif index == 1:
		print(ProjectSettings.get_setting("display/window/stretch/aspect"))
		ProjectSettings.set_setting("display/window/stretch/aspect", "expand")
		print(ProjectSettings.get_setting("display/window/stretch/aspect"))
	elif index == 2:
		pass
	elif index == 3:
		pass
	elif index == 4:
		pass

func _on_ch_BackgroundWhite_pressed():
	settings["RECIPE"]["background"] = "white"
	var config_file = File.new()
	config_file.open("user://config.json", File.WRITE)
	config_file.store_line(to_json(settings))
	$UI2/Menu/Recipe2/Control/background_white/cb_BackgroundWhite.pressed = true
	$UI2/Menu/Recipe2/Control/background_scroll/cb_BackgroundScroll.pressed = false

func _on_cb_BackgroundScroll_pressed():
	settings["RECIPE"]["background"] = "scroll"
	var config_file = File.new()
	config_file.open("user://config.json", File.WRITE)
	config_file.store_line(to_json(settings))
	$UI2/Menu/Recipe2/Control/background_white/cb_BackgroundWhite.pressed = false
	$UI2/Menu/Recipe2/Control/background_scroll/cb_BackgroundScroll.pressed = true

func _on_cb_ClassicTheme_pressed():
	settings["RECIPE"]["theme"] = "classic"
	var config_file = File.new()
	config_file.open("user://config.json", File.WRITE)
	config_file.store_line(to_json(settings))
	$UI2/Menu/Recipe2/Control/theme_classic/cb_ClassicTheme.pressed = true
	$UI2/Menu/Recipe2/Control/theme_material/cb_MaterialTheme.pressed = false
	$UI2/Menu/Recipe2/Control/theme_watercolor/cb_WaterColorTheme.pressed = false

func _on_cb_MaterialTheme_pressed():
	settings["RECIPE"]["theme"] = "material"
	var config_file = File.new()
	config_file.open("user://config.json", File.WRITE)
	config_file.store_line(to_json(settings))
	$UI2/Menu/Recipe2/Control/theme_classic/cb_ClassicTheme.pressed = false
	$UI2/Menu/Recipe2/Control/theme_material/cb_MaterialTheme.pressed = true
	$UI2/Menu/Recipe2/Control/theme_watercolor/cb_WaterColorTheme.pressed = false

func _on_cb_WaterColorTheme_pressed():
	settings["RECIPE"]["theme"] = "watercolor"
	var config_file = File.new()
	config_file.open("user://config.json", File.WRITE)
	config_file.store_line(to_json(settings))
	$UI2/Menu/Recipe2/Control/theme_classic/cb_ClassicTheme.pressed = false
	$UI2/Menu/Recipe2/Control/theme_material/cb_MaterialTheme.pressed = false
	$UI2/Menu/Recipe2/Control/theme_watercolor/cb_WaterColorTheme.pressed = true

func _on_cb_Sound_pressed():
	settings["GENERIC"]["sound"] = $UI2/Menu/Recipe/Control/sound/cb_Sound.pressed
	var config_file = File.new()
	config_file.open("user://config.json", File.WRITE)
	config_file.store_line(to_json(settings))
	AudioServer.set_bus_mute(0,!settings["GENERIC"]["sound"])

func _on_cb_Effects_pressed():
	settings["GENERIC"]["effects"] = $UI2/Menu/Recipe/Control/effects/cb_Effects.pressed
	var config_file = File.new()
	config_file.open("user://config.json", File.WRITE)
	config_file.store_line(to_json(settings))
	AudioServer.set_bus_mute(1,!settings["GENERIC"]["effects"])
