extends Control

onready var main = $"../.."

var moving = false
onready var walls = [get_node("../../Game/Box/Wall1"), get_node("../../Game/Box/Wall2")]
onready var guy = $Guy
var guy_default = preload("res://assets/sprites/objects/guy_default.png")
var guy_dropping = preload("res://assets/sprites/objects/guy_dropping.png")
var guy_blocked = preload("res://assets/sprites/objects/guy_blocked.png")
var guy_cold = preload("res://assets/sprites/objects/guy_cold.png")
var guy_cold_dropping = preload("res://assets/sprites/objects/guy_cold_dropping.png")

var next_destination = Vector2(250, 0)
const SMOOTH_SPEED = 10
var position_difference = Vector2()
var smoothed_velocity = Vector2()

onready var point = $Point
#levels below preloaded for testing purposes
onready var levels = [preload("res://scenes/objects/level1.tscn"), preload("res://scenes/objects/level2.tscn"), preload("res://scenes/objects/level3.tscn"), preload("res://scenes/objects/level4.tscn"), preload("res://scenes/objects/level5.tscn"), preload("res://scenes/objects/level6.tscn"), preload("res://scenes/objects/level7.tscn"), preload("res://scenes/objects/level8.tscn"), preload("res://scenes/objects/level9.tscn"), preload("res://scenes/objects/level10.tscn"), preload("res://scenes/objects/level11.tscn")]
onready var drops = $"../../Game/Drops"

onready var powerups = {"ICE": preload("res://scenes/objects/ice.tscn"), "SEEDS": preload("res://scenes/objects/seed.tscn")}

func _ready():
	pass # Replace with function body.

func _on_Tap_button_down():
	guy.texture = guy_dropping
	if main.active_powerup == "ICE":
		guy.texture = guy_cold_dropping
	if main.active_powerup != "SEEDS":
		moving = true
	else:
		moving = false

func _on_Tap_button_up():
	moving = false
	spawn()
	guy.texture = guy_default

func spawn():
	if $Point/Area2D.get_overlapping_bodies().size() == 0:
		if main.active_powerup == "NONE":
			var pos = point.rect_global_position
			var new = levels[main.next_drop-1].instance()
			new.position.x = pos.x
			drops.add_child(new)
			main.dropped()
		elif main.active_powerup == "ICE":
			spawn_ice()
		elif main.active_powerup == "SEEDS":
			shoot_seed()

func spawn_ice():
	var pos = point.rect_global_position
	var new = powerups["ICE"].instance()
	new.position.x = pos.x
	drops.add_child(new)
	main.active_powerup = "NONE"
	#return cloud to normal

var seeds_left = 3
func shoot_seed():
	if seeds_left > 0:
		seeds_left -=1
		var pos = point.rect_global_position
		var new = powerups["SEEDS"].instance()
		new.position.x = pos.x
		new.apply_impulse(Vector2.ZERO, (get_global_mouse_position()-pos))
		drops.add_child(new)
	if seeds_left == 0:
		main.active_powerup = "NONE"
		seeds_left = 3
		$Hold.visible = false

func _physics_process(delta):
	if moving == true and get_global_mouse_position().x > 60 and get_global_mouse_position().x < 445:
		next_destination = get_global_mouse_position()
	position_difference = next_destination.x - rect_position.x
	smoothed_velocity = position_difference * SMOOTH_SPEED * delta
	rect_position.x += smoothed_velocity-(rect_size.x/12)
